/*
 * Decompiled with CFR 0.152.
 */
package com.orsoncharts.demo;

import com.orsoncharts.Chart3D;
import com.orsoncharts.Chart3DFactory;
import com.orsoncharts.axis.IntegerTickSelector;
import com.orsoncharts.axis.NumberAxis3D;
import com.orsoncharts.data.xyz.XYZDataset;
import com.orsoncharts.data.xyz.XYZSeries;
import com.orsoncharts.data.xyz.XYZSeriesCollection;
import com.orsoncharts.graphics3d.Dimension3D;
import com.orsoncharts.plot.XYZPlot;
import java.awt.Color;

public class XYZLineChart3D1 {
    public static Chart3D createChart(XYZDataset dataset) {
        Chart3D chart = Chart3DFactory.createXYZLineChart("XYZ Line Chart Demo", "Orson Charts", dataset, "Day", "Index", "Station");
        chart.setChartBoxColor(new Color(255, 255, 255, 128));
        XYZPlot plot = (XYZPlot)chart.getPlot();
        plot.setDimensions(new Dimension3D(15.0, 3.0, 8.0));
        NumberAxis3D zAxis = (NumberAxis3D)plot.getZAxis();
        zAxis.setTickSelector(new IntegerTickSelector());
        return chart;
    }

    public static XYZDataset<String> createDataset() {
        XYZSeriesCollection<String> dataset = new XYZSeriesCollection<String>();
        for (int s = 1; s < 24; ++s) {
            XYZSeries<String> series = new XYZSeries<String>("Series " + s);
            double y = 1.0;
            for (int i = 0; i < 3000; ++i) {
                series.add(i, y *= 1.0 + (Math.random() - 0.499) / 10.0, s);
            }
            dataset.add(series);
        }
        return dataset;
    }
}

