/*
 * Decompiled with CFR 0.152.
 */
package com.orsoncharts.demo.swing;

import com.orsoncharts.Chart3D;
import com.orsoncharts.Chart3DFactory;
import com.orsoncharts.Chart3DPanel;
import com.orsoncharts.axis.ValueAxis3D;
import com.orsoncharts.data.function.Function3D;
import com.orsoncharts.demo.swing.DemoPanel;
import com.orsoncharts.demo.swing.ExitOnClose;
import com.orsoncharts.demo.swing.OrsonChartsDemo;
import com.orsoncharts.graphics3d.Dimension3D;
import com.orsoncharts.graphics3d.ViewPoint3D;
import com.orsoncharts.graphics3d.swing.DisplayPanel3D;
import com.orsoncharts.plot.XYZPlot;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class AxisRangeDemo6
extends JFrame {
    public AxisRangeDemo6(String title) {
        super(title);
        this.addWindowListener(new ExitOnClose());
        this.getContentPane().add(AxisRangeDemo6.createDemoPanel());
    }

    public static JPanel createDemoPanel() {
        CustomDemoPanel content = new CustomDemoPanel(new BorderLayout());
        content.setPreferredSize(OrsonChartsDemo.DEFAULT_CONTENT_SIZE);
        Function3D function = new Function3D(){

            @Override
            public double getValue(double x, double z) {
                return Math.cos(x) * Math.sin(z);
            }
        };
        Chart3D chart = Chart3DFactory.createSurfaceChart("AxisRangeDemo6", "Chart created with Orson Charts", function, "X", "Y", "Z");
        XYZPlot plot = (XYZPlot)chart.getPlot();
        plot.setDimensions(new Dimension3D(10.0, 4.0, 10.0));
        plot.getXAxis().setRange(-5.0, 5.0);
        plot.getZAxis().setRange(-5.0, 5.0);
        chart.setViewPoint(ViewPoint3D.createAboveLeftViewPoint(40.0));
        Chart3DPanel chartPanel = new Chart3DPanel(chart);
        content.setChartPanel(chartPanel);
        chartPanel.zoomToFit(OrsonChartsDemo.DEFAULT_CONTENT_SIZE);
        content.add(new DisplayPanel3D(chartPanel));
        return content;
    }

    public static void main(String[] args) {
        AxisRangeDemo6 app = new AxisRangeDemo6("OrsonCharts : AxisRangeDemo6.java");
        app.pack();
        app.setVisible(true);
    }

    static class CustomDemoPanel
    extends DemoPanel
    implements ChangeListener {
        private JSlider xslider1 = new JSlider(0, 50);
        private JSlider xslider2;
        private JSlider yslider1;
        private JSlider yslider2;
        private JSlider zslider1;
        private JSlider zslider2;

        public CustomDemoPanel(LayoutManager layout) {
            super(layout);
            this.xslider1.setValue(0);
            this.xslider2 = new JSlider(50, 100);
            this.xslider2.setValue(100);
            this.xslider1.addChangeListener(this);
            this.xslider2.addChangeListener(this);
            this.yslider1 = new JSlider(0, 50);
            this.yslider1.setValue(0);
            this.yslider2 = new JSlider(50, 100);
            this.yslider2.setValue(100);
            this.yslider1.addChangeListener(this);
            this.yslider2.addChangeListener(this);
            this.zslider1 = new JSlider(0, 50);
            this.zslider1.setValue(0);
            this.zslider2 = new JSlider(50, 100);
            this.zslider2.setValue(100);
            this.zslider1.addChangeListener(this);
            this.zslider2.addChangeListener(this);
            JPanel rangePanel = new JPanel(new GridLayout(3, 1));
            JPanel xPanel = new JPanel(new FlowLayout());
            xPanel.add(new JLabel("X axis: "));
            xPanel.add(new JLabel("Lower bound: "));
            xPanel.add(this.xslider1);
            xPanel.add(new JLabel("Upper bound: "));
            xPanel.add(this.xslider2);
            rangePanel.add(xPanel);
            JPanel yPanel = new JPanel(new FlowLayout());
            yPanel.add(new JLabel("Y axis: "));
            yPanel.add(new JLabel("Lower bound: "));
            yPanel.add(this.yslider1);
            yPanel.add(new JLabel("Upper bound: "));
            yPanel.add(this.yslider2);
            rangePanel.add(yPanel);
            JPanel zPanel = new JPanel(new FlowLayout());
            zPanel.add(new JLabel("Z axis: "));
            zPanel.add(new JLabel("Lower bound: "));
            zPanel.add(this.zslider1);
            zPanel.add(new JLabel("Upper bound: "));
            zPanel.add(this.zslider2);
            rangePanel.add(zPanel);
            this.add((Component)rangePanel, "South");
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            double zmax;
            double ymax;
            double xmax;
            Chart3D chart = (Chart3D)this.getChartPanel().getDrawable();
            XYZPlot plot = (XYZPlot)chart.getPlot();
            ValueAxis3D xAxis = plot.getXAxis();
            double xmin = (double)this.xslider1.getValue() / 10.0 - 5.0;
            if (xmin != (xmax = (double)this.xslider2.getValue() / 10.0 - 5.0)) {
                xAxis.setRange(xmin, xmax);
            }
            ValueAxis3D yAxis = plot.getYAxis();
            double ymin = (double)this.yslider1.getValue() / 40.0 - 1.0;
            if (ymin != (ymax = (double)this.yslider2.getValue() / 40.0 - 1.0)) {
                yAxis.setRange(ymin, ymax);
            }
            ValueAxis3D zAxis = plot.getZAxis();
            double zmin = (double)this.zslider1.getValue() / 10.0 - 5.0;
            if (zmin != (zmax = (double)this.zslider2.getValue() / 10.0 - 5.0)) {
                zAxis.setRange(zmin, zmax);
            }
        }
    }
}

