/*
 * Decompiled with CFR 0.152.
 */
package com.orsoncharts.demo.swing;

import com.orsoncharts.Chart3D;
import com.orsoncharts.Chart3DPanel;
import com.orsoncharts.axis.StandardCategoryAxis3D;
import com.orsoncharts.data.KeyedValues3DItemKey;
import com.orsoncharts.data.KeyedValues3DItemKeys;
import com.orsoncharts.data.category.CategoryDataset3D;
import com.orsoncharts.demo.CategoryMarker1;
import com.orsoncharts.demo.HighlightCategoryColorSource;
import com.orsoncharts.demo.swing.DemoPanel;
import com.orsoncharts.demo.swing.ExitOnClose;
import com.orsoncharts.demo.swing.OrsonChartsDemo;
import com.orsoncharts.graphics3d.RenderedElement;
import com.orsoncharts.graphics3d.swing.DisplayPanel3D;
import com.orsoncharts.interaction.Chart3DMouseEvent;
import com.orsoncharts.interaction.Chart3DMouseListener;
import com.orsoncharts.interaction.InteractiveElementType;
import com.orsoncharts.interaction.KeyedValues3DItemSelection;
import com.orsoncharts.interaction.StandardKeyedValues3DItemSelection;
import com.orsoncharts.label.StandardCategoryItemLabelGenerator;
import com.orsoncharts.marker.CategoryMarker;
import com.orsoncharts.plot.CategoryPlot3D;
import com.orsoncharts.renderer.category.BarRenderer3D;
import com.orsoncharts.style.ChartStyler;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class CategoryMarkerDemo1
extends JFrame {
    public CategoryMarkerDemo1(String title) {
        super(title);
        this.addWindowListener(new ExitOnClose());
        this.getContentPane().add(CategoryMarkerDemo1.createDemoPanel());
    }

    public static JPanel createDemoPanel() {
        CustomDemoPanel content = new CustomDemoPanel(new BorderLayout());
        content.setPreferredSize(OrsonChartsDemo.DEFAULT_CONTENT_SIZE);
        CategoryDataset3D dataset = CategoryMarker1.createDataset();
        Chart3D chart = CategoryMarker1.createChart(dataset);
        Chart3DPanel chartPanel = new Chart3DPanel(chart);
        chartPanel.setMargin(0.3);
        chartPanel.getViewPoint().panLeftRight(-0.3);
        chartPanel.getViewPoint().moveUpDown(-0.12);
        chartPanel.getViewPoint().roll(-0.05235987755982988);
        content.setChartPanel(chartPanel);
        chartPanel.zoomToFit(OrsonChartsDemo.DEFAULT_CONTENT_SIZE);
        chartPanel.addChartMouseListener(content);
        content.add(new DisplayPanel3D(chartPanel));
        return content;
    }

    public static void main(String[] args) {
        CategoryMarkerDemo1 app = new CategoryMarkerDemo1("OrsonCharts: CategoryMarkerDemo1.java");
        app.pack();
        app.setVisible(true);
    }

    static class CustomDemoPanel
    extends DemoPanel
    implements ActionListener,
    Chart3DMouseListener {
        private String selectedRowKey;
        private String selectedColumnKey;
        private JCheckBox itemLabelCheckBox;

        public CustomDemoPanel(LayoutManager layout) {
            super(layout);
            JPanel controlPanel = new JPanel(new FlowLayout());
            this.itemLabelCheckBox = new JCheckBox("Show item labels?");
            this.itemLabelCheckBox.addActionListener(this);
            controlPanel.add(this.itemLabelCheckBox);
            this.selectedRowKey = "Apple";
            this.selectedColumnKey = "Q4/12";
            this.add((Component)controlPanel, "South");
        }

        private void updateColorSource(String selectedRow, String selectedColumn) {
            HighlightCategoryColorSource colorSource = (HighlightCategoryColorSource)this.getRenderer().getColorSource();
            int rowIndex = this.getPlot().getDataset().getRowIndex(selectedRow);
            int columnIndex = this.getPlot().getDataset().getColumnIndex(selectedColumn);
            colorSource.setHighlightRowIndex(rowIndex);
            colorSource.setHighlightColumnIndex(columnIndex);
        }

        private void updateItemSelection(String selectedRow, String selectedColumn) {
            StandardKeyedValues3DItemSelection itemSelection = (StandardKeyedValues3DItemSelection)this.getItemSelection();
            itemSelection.clear();
            if (this.itemLabelCheckBox.isSelected()) {
                itemSelection.addAll(KeyedValues3DItemKeys.itemKeysForColumn(this.getPlot().getDataset(), selectedColumn));
                itemSelection.addAll(KeyedValues3DItemKeys.itemKeysForRow(this.getPlot().getDataset(), selectedRow));
            }
        }

        private CategoryPlot3D getPlot() {
            Chart3D chart = this.getChartPanel().getChart();
            return (CategoryPlot3D)chart.getPlot();
        }

        private BarRenderer3D getRenderer() {
            return (BarRenderer3D)this.getPlot().getRenderer();
        }

        private KeyedValues3DItemSelection getItemSelection() {
            StandardCategoryItemLabelGenerator generator = (StandardCategoryItemLabelGenerator)this.getRenderer().getItemLabelGenerator();
            return generator.getItemSelection();
        }

        private void handleSelectItem(Comparable rowKey, Comparable columnKey) {
            StandardCategoryAxis3D columnAxis;
            CategoryMarker columnMarker;
            Chart3D chart = this.getChartPanel().getChart();
            chart.setNotify(false);
            CategoryPlot3D plot = this.getPlot();
            StandardCategoryAxis3D rowAxis = (StandardCategoryAxis3D)plot.getRowAxis();
            CategoryMarker rowMarker = rowAxis.getMarker("RM1");
            if (rowMarker == null) {
                rowMarker = new CategoryMarker((Comparable<?>)((Object)""));
                rowMarker.receive(new ChartStyler(chart.getStyle()));
            }
            if ((columnMarker = (columnAxis = (StandardCategoryAxis3D)plot.getColumnAxis()).getMarker("CM1")) == null) {
                columnMarker = new CategoryMarker((Comparable<?>)((Object)""));
                columnMarker.receive(new ChartStyler(chart.getStyle()));
            }
            this.selectedRowKey = rowKey.toString();
            this.selectedColumnKey = columnKey.toString();
            rowMarker.setCategory((Comparable<?>)((Object)this.selectedRowKey));
            columnMarker.setCategory((Comparable<?>)((Object)this.selectedColumnKey));
            this.updateColorSource(this.selectedRowKey, this.selectedColumnKey);
            this.updateItemSelection(this.selectedRowKey, this.selectedColumnKey);
            chart.setNotify(true);
        }

        private void handleSelectRow(Comparable rowKey) {
            this.handleSelectItem(rowKey, (Comparable)((Object)this.selectedColumnKey));
        }

        private void handleSelectColumn(Comparable columnKey) {
            this.handleSelectItem((Comparable)((Object)this.selectedRowKey), columnKey);
        }

        @Override
        public void chartMouseClicked(Chart3DMouseEvent event) {
            RenderedElement element = event.getElement();
            if (element == null) {
                return;
            }
            KeyedValues3DItemKey key = (KeyedValues3DItemKey)element.getProperty("key");
            if (key != null) {
                this.handleSelectItem((Comparable)key.getRowKey(), (Comparable)key.getColumnKey());
            } else if (InteractiveElementType.CATEGORY_AXIS_TICK_LABEL.equals(element.getType())) {
                String label = (String)element.getProperty("label");
                String axisStr = (String)element.getProperty("axis");
                if (axisStr.equals("row")) {
                    this.handleSelectRow((Comparable)((Object)label));
                } else {
                    this.handleSelectColumn((Comparable)((Object)label));
                }
            } else if (InteractiveElementType.LEGEND_ITEM.equals(element.getType())) {
                Comparable seriesKey = (Comparable)element.getProperty("series_key");
                this.handleSelectRow(seriesKey);
            }
        }

        @Override
        public void chartMouseMoved(Chart3DMouseEvent event) {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.updateItemSelection(this.selectedRowKey, this.selectedColumnKey);
            this.getChartPanel().getChart().setNotify(true);
        }
    }
}

