/*
 * Decompiled with CFR 0.152.
 */
package com.orsoncharts.demo.swing;

import com.orsoncharts.Chart3D;
import com.orsoncharts.Chart3DPanel;
import com.orsoncharts.demo.DemoDescription;
import com.orsoncharts.demo.swing.DemoPanel;
import com.orsoncharts.demo.swing.OrsonChartsDemo;
import com.orsoncharts.demo.swing.OrsonChartsDemoComponent;
import java.awt.Color;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import javax.swing.BorderFactory;
import javax.swing.JPanel;

public class DemoDisplayer
implements Runnable {
    private OrsonChartsDemoComponent demoComp;
    private DemoDescription demoDescription;

    public DemoDisplayer(OrsonChartsDemoComponent demoComp, DemoDescription d) {
        this.demoComp = demoComp;
        this.demoDescription = d;
    }

    @Override
    public void run() {
        try {
            String f;
            URL descriptionURL;
            Class<?> c = Class.forName(this.demoDescription.getClassName());
            Method m = c.getDeclaredMethod("createDemoPanel", null);
            JPanel panel = (JPanel)m.invoke(null, (Object[])null);
            panel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4), BorderFactory.createLineBorder(Color.BLACK)));
            this.demoComp.getChartContainer().removeAll();
            this.demoComp.getChartContainer().add(panel);
            this.demoComp.getChartContainer().validate();
            if (panel instanceof DemoPanel) {
                DemoPanel demoPanel = (DemoPanel)panel;
                for (Chart3DPanel cp3d : demoPanel.getChartPanels()) {
                    if (this.demoComp.getChartStyle() != null) {
                        Chart3D chart = (Chart3D)cp3d.getDrawable();
                        chart.setStyle(this.demoComp.getChartStyle());
                    }
                    cp3d.zoomToFit();
                }
            }
            if ((descriptionURL = OrsonChartsDemo.class.getResource(f = this.demoDescription.getDescriptionFileName())) != null) {
                try {
                    this.demoComp.getChartDescriptionPane().setPage(descriptionURL);
                }
                catch (IOException e) {
                    System.err.println("Attempted to read a bad URL: " + descriptionURL);
                }
            }
        }
        catch (ClassNotFoundException e1) {
            e1.printStackTrace();
        }
        catch (NoSuchMethodException e2) {
            e2.printStackTrace();
        }
        catch (InvocationTargetException e3) {
            e3.printStackTrace();
        }
        catch (IllegalAccessException e4) {
            e4.printStackTrace();
        }
    }
}

