/*
 * Decompiled with CFR 0.152.
 */
package com.orsoncharts.demo.swing;

import com.orsoncharts.Chart3D;
import com.orsoncharts.Chart3DPanel;
import com.orsoncharts.data.xyz.XYZDataset;
import com.orsoncharts.data.xyz.XYZItemKey;
import com.orsoncharts.demo.HighlightXYZColorSource;
import com.orsoncharts.demo.RangeMarker1;
import com.orsoncharts.demo.swing.DemoPanel;
import com.orsoncharts.demo.swing.ExitOnClose;
import com.orsoncharts.demo.swing.OrsonChartsDemo;
import com.orsoncharts.graphics3d.RenderedElement;
import com.orsoncharts.graphics3d.swing.DisplayPanel3D;
import com.orsoncharts.interaction.Chart3DMouseEvent;
import com.orsoncharts.interaction.Chart3DMouseListener;
import com.orsoncharts.interaction.StandardXYZDataItemSelection;
import com.orsoncharts.label.StandardXYZItemLabelGenerator;
import com.orsoncharts.marker.RangeMarker;
import com.orsoncharts.plot.XYZPlot;
import com.orsoncharts.renderer.xyz.ScatterXYZRenderer;
import com.orsoncharts.renderer.xyz.StandardXYZColorSource;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class RangeMarkerDemo1
extends JFrame {
    public RangeMarkerDemo1(String title) {
        super(title);
        this.addWindowListener(new ExitOnClose());
        this.getContentPane().add(RangeMarkerDemo1.createDemoPanel());
    }

    public static JPanel createDemoPanel() {
        CustomDemoPanel content = new CustomDemoPanel(new BorderLayout());
        content.setPreferredSize(OrsonChartsDemo.DEFAULT_CONTENT_SIZE);
        XYZDataset<String> dataset = RangeMarker1.createDataset();
        Chart3D chart = RangeMarker1.createChart(dataset);
        Chart3DPanel chartPanel = new Chart3DPanel(chart);
        content.setChartPanel(chartPanel);
        chartPanel.addChartMouseListener(content);
        chartPanel.zoomToFit(OrsonChartsDemo.DEFAULT_CONTENT_SIZE);
        content.add(new DisplayPanel3D(chartPanel));
        return content;
    }

    public static void main(String[] args) {
        RangeMarkerDemo1 app = new RangeMarkerDemo1("OrsonCharts : RangeMarkerDemo1.java");
        app.pack();
        app.setVisible(true);
    }

    static class CustomDemoPanel
    extends DemoPanel
    implements ActionListener,
    Chart3DMouseListener {
        private JCheckBox checkBox = new JCheckBox("Highlight items within range intersection");

        public CustomDemoPanel(LayoutManager layout) {
            super(layout);
            this.checkBox.setSelected(true);
            this.checkBox.addActionListener(this);
            JPanel controlPanel = new JPanel(new FlowLayout());
            controlPanel.add(this.checkBox);
            this.add((Component)controlPanel, "South");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Chart3D chart = (Chart3D)this.getChartPanel().getDrawable();
            XYZPlot plot = (XYZPlot)chart.getPlot();
            RangeMarker xm = (RangeMarker)plot.getXAxis().getMarker("X1");
            RangeMarker ym = (RangeMarker)plot.getYAxis().getMarker("Y1");
            RangeMarker zm = (RangeMarker)plot.getZAxis().getMarker("Z1");
            if (this.checkBox.isSelected()) {
                HighlightXYZColorSource colorSource = new HighlightXYZColorSource(plot.getDataset(), Color.RED, xm.getRange(), ym.getRange(), zm.getRange(), chart.getStyle().getStandardColors());
                plot.getRenderer().setColorSource(colorSource);
            } else {
                StandardXYZColorSource colorSource = new StandardXYZColorSource(chart.getStyle().getStandardColors());
                plot.getRenderer().setColorSource(colorSource);
            }
        }

        @Override
        public void chartMouseClicked(Chart3DMouseEvent event) {
            RenderedElement element = event.getElement();
            XYZItemKey key = (XYZItemKey)element.getProperty("key");
            if (key == null) {
                this.getItemSelection().clear();
                this.getChartPanel().getChart().setNotify(true);
                return;
            }
            if (event.getTrigger().isShiftDown()) {
                this.getItemSelection().add(key);
            } else {
                this.getItemSelection().clear();
                this.getItemSelection().add(key);
            }
            this.getChartPanel().getChart().setNotify(true);
        }

        private StandardXYZDataItemSelection getItemSelection() {
            Chart3D chart = this.getChartPanel().getChart();
            XYZPlot plot = (XYZPlot)chart.getPlot();
            ScatterXYZRenderer renderer = (ScatterXYZRenderer)plot.getRenderer();
            StandardXYZItemLabelGenerator itemLabelGenerator = (StandardXYZItemLabelGenerator)renderer.getItemLabelGenerator();
            return (StandardXYZDataItemSelection)itemLabelGenerator.getItemSelection();
        }

        @Override
        public void chartMouseMoved(Chart3DMouseEvent event) {
        }
    }
}

