/*
 * Decompiled with CFR 0.152.
 */
package com.orsoncharts.demo.swing;

import com.orsoncharts.demo.swing.ExitOnClose;
import com.orsoncharts.demo.swing.OrsonChartsDemo;
import com.orsoncharts.graphics3d.DefaultDrawable3D;
import com.orsoncharts.graphics3d.Object3D;
import com.orsoncharts.graphics3d.Point3D;
import com.orsoncharts.graphics3d.Rotate3D;
import com.orsoncharts.graphics3d.ViewPoint3D;
import com.orsoncharts.graphics3d.World;
import com.orsoncharts.graphics3d.swing.DisplayPanel3D;
import com.orsoncharts.graphics3d.swing.Panel3D;
import java.awt.BorderLayout;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class ViewPoint3DDemo
extends JFrame {
    List<Point3D> xlist;
    List<Point3D> ylist;
    List<Point3D> zlist;
    Panel3D panel3D;

    public ViewPoint3DDemo(String title) {
        super(title);
        this.addWindowListener(new ExitOnClose());
        this.getContentPane().add(this.createDemoPanel());
    }

    public final JPanel createDemoPanel() {
        JPanel content = new JPanel(new BorderLayout());
        content.setPreferredSize(OrsonChartsDemo.DEFAULT_CONTENT_SIZE);
        World world = new World();
        world.add(Object3D.createCube(1.0, 0.0, 0.0, 0.0, Color.BLUE));
        ViewPoint3D vp = new ViewPoint3D(new Point3D(10.0, 10.0, 10.0), 0.0);
        this.xlist = this.addRing(true, world, new Point3D(0.0, 5.0, 0.0), Point3D.UNIT_X, Color.GREEN);
        this.ylist = this.addRing(true, world, new Point3D(0.0, 0.0, 5.0), Point3D.UNIT_Y, Color.ORANGE);
        this.zlist = this.addRing(true, world, new Point3D(0.0, 5.0, 0.0), Point3D.UNIT_Z, Color.RED);
        DefaultDrawable3D drawable = new DefaultDrawable3D(world);
        this.panel3D = new Panel3D(drawable);
        this.panel3D.setViewPoint(vp);
        content.add(new DisplayPanel3D(this.panel3D));
        return content;
    }

    private List<Point3D> addRing(boolean b, World world, Point3D pt, Point3D v1, Color color) {
        boolean first = true;
        ArrayList<Point3D> result = new ArrayList<Point3D>();
        Rotate3D r = new Rotate3D(Point3D.ORIGIN, v1, 0.0);
        for (int i = 0; i < 60; ++i) {
            r.setAngle(0.10471975511965977 * (double)i);
            Point3D p = r.applyRotation(pt);
            result.add(p);
            if (!b) continue;
            if (first) {
                world.add(Object3D.createCube(0.2, p.x, p.y, p.z, Color.RED));
                first = false;
                continue;
            }
            world.add(Object3D.createCube(0.2, p.x, p.y, p.z, color));
        }
        return result;
    }

    public static void main(String[] args) {
        ViewPoint3DDemo app = new ViewPoint3DDemo("OrsonCharts: ViewPointDemo.java");
        app.pack();
        app.setVisible(true);
    }
}

