/*
 * Decompiled with CFR 0.152.
 */
package com.orsoncharts.data;

import com.orsoncharts.data.DefaultKeyedValues;
import com.orsoncharts.data.KeyedValues2D;
import com.orsoncharts.util.ArgChecks;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public final class DefaultKeyedValues2D<R extends Comparable<R>, C extends Comparable<C>, T>
implements KeyedValues2D<R, C, T>,
Serializable {
    List<R> rowKeys;
    List<C> columnKeys;
    List<DefaultKeyedValues<C, T>> data;

    public DefaultKeyedValues2D() {
        this(new ArrayList(), new ArrayList());
    }

    public DefaultKeyedValues2D(List<R> rowKeys, List<C> columnKeys) {
        ArgChecks.nullNotPermitted(rowKeys, "rowKeys");
        ArgChecks.nullNotPermitted(columnKeys, "columnKeys");
        this.rowKeys = new ArrayList<R>(rowKeys);
        this.columnKeys = new ArrayList<C>(columnKeys);
        this.data = new ArrayList<DefaultKeyedValues<C, T>>();
        for (int i = 0; i < rowKeys.size(); ++i) {
            this.data.add(new DefaultKeyedValues(columnKeys));
        }
    }

    @Override
    public R getRowKey(int rowIndex) {
        return (R)((Comparable)this.rowKeys.get(rowIndex));
    }

    @Override
    public C getColumnKey(int columnIndex) {
        return (C)((Comparable)this.columnKeys.get(columnIndex));
    }

    @Override
    public int getRowIndex(R rowKey) {
        ArgChecks.nullNotPermitted(rowKey, "rowKey");
        return this.rowKeys.indexOf(rowKey);
    }

    @Override
    public int getColumnIndex(C columnKey) {
        ArgChecks.nullNotPermitted(columnKey, "columnKey");
        return this.columnKeys.indexOf(columnKey);
    }

    @Override
    public List<R> getRowKeys() {
        return new ArrayList<R>(this.rowKeys);
    }

    @Override
    public List<C> getColumnKeys() {
        return new ArrayList<C>(this.columnKeys);
    }

    @Override
    public int getRowCount() {
        return this.rowKeys.size();
    }

    @Override
    public int getColumnCount() {
        return this.columnKeys.size();
    }

    @Override
    public T getValue(R rowKey, C columnKey) {
        int rowIndex = this.getRowIndex(rowKey);
        int columnIndex = this.getColumnIndex(columnKey);
        return this.getValue(rowIndex, columnIndex);
    }

    @Override
    public T getValue(int rowIndex, int columnIndex) {
        return this.data.get(rowIndex).getValue(columnIndex);
    }

    @Override
    public double getDoubleValue(int rowIndex, int columnIndex) {
        T n = this.getValue(rowIndex, columnIndex);
        if (n != null && n instanceof Number) {
            return ((Number)n).doubleValue();
        }
        return Double.NaN;
    }

    public void setValue(T n, R rowKey, C columnKey) {
        ArgChecks.nullNotPermitted(rowKey, "rowKey");
        ArgChecks.nullNotPermitted(columnKey, "columnKey");
        if (this.data.isEmpty()) {
            this.rowKeys.add(rowKey);
            this.columnKeys.add(columnKey);
            DefaultKeyedValues<C, T> dkvs = new DefaultKeyedValues<C, T>();
            dkvs.put(columnKey, n);
            this.data.add(dkvs);
        } else {
            int rowIndex = this.getRowIndex(rowKey);
            int columnIndex = this.getColumnIndex(columnKey);
            if (rowIndex >= 0) {
                DefaultKeyedValues<C, T> dkvs = this.data.get(rowIndex);
                if (columnIndex >= 0) {
                    dkvs.put(columnKey, n);
                } else {
                    this.columnKeys.add(columnKey);
                    for (DefaultKeyedValues<C, Object> defaultKeyedValues : this.data) {
                        defaultKeyedValues.put(columnKey, null);
                    }
                    dkvs.put(columnKey, n);
                }
            } else if (columnIndex >= 0) {
                this.rowKeys.add(rowKey);
                DefaultKeyedValues<C, T> d = new DefaultKeyedValues<C, T>(this.columnKeys);
                d.put(columnKey, n);
                this.data.add(d);
            } else {
                this.rowKeys.add(rowKey);
                this.columnKeys.add(columnKey);
                for (DefaultKeyedValues<C, Object> defaultKeyedValues : this.data) {
                    defaultKeyedValues.put(columnKey, null);
                }
                DefaultKeyedValues d = new DefaultKeyedValues(this.columnKeys);
                d.put(columnKey, n);
                this.data.add(d);
            }
        }
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof DefaultKeyedValues2D)) {
            return false;
        }
        DefaultKeyedValues2D that = (DefaultKeyedValues2D)obj;
        if (!this.rowKeys.equals(that.rowKeys)) {
            return false;
        }
        if (!this.columnKeys.equals(that.columnKeys)) {
            return false;
        }
        return this.data.equals(that.data);
    }
}

