/*
 * Decompiled with CFR 0.152.
 */
package com.orsoncharts.data.xyz;

import com.orsoncharts.data.Series3DChangeEvent;
import com.orsoncharts.data.Series3DChangeListener;
import com.orsoncharts.data.xyz.XYZDataItem;
import com.orsoncharts.util.ArgChecks;
import com.orsoncharts.util.ObjectUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.swing.event.EventListenerList;

public class XYZSeries<K extends Comparable<K>>
implements Serializable {
    private final K key;
    private final List<XYZDataItem> items;
    private EventListenerList listeners;
    private boolean notify;

    public XYZSeries(K key) {
        ArgChecks.nullNotPermitted(key, "key");
        this.key = key;
        this.items = new ArrayList<XYZDataItem>();
        this.listeners = new EventListenerList();
        this.notify = true;
    }

    public K getKey() {
        return this.key;
    }

    public int getItemCount() {
        return this.items.size();
    }

    public List<XYZDataItem> getItems() {
        return new ArrayList<XYZDataItem>(this.items);
    }

    public double getXValue(int itemIndex) {
        return this.items.get(itemIndex).getX();
    }

    public double getYValue(int itemIndex) {
        return this.items.get(itemIndex).getY();
    }

    public double getZValue(int itemIndex) {
        return this.items.get(itemIndex).getZ();
    }

    public void add(double x, double y, double z) {
        this.add(new XYZDataItem(x, y, z));
    }

    public void add(XYZDataItem item) {
        ArgChecks.nullNotPermitted(item, "item");
        this.items.add(item);
        this.fireSeriesChanged();
    }

    public void remove(int itemIndex) {
        this.items.remove(itemIndex);
        this.fireSeriesChanged();
    }

    public void addChangeListener(Series3DChangeListener listener) {
        this.listeners.add(Series3DChangeListener.class, listener);
    }

    public void removeChangeListener(Series3DChangeListener listener) {
        this.listeners.remove(Series3DChangeListener.class, listener);
    }

    public boolean getNotify() {
        return this.notify;
    }

    public void setNotify(boolean notify) {
        if (this.notify != notify) {
            this.notify = notify;
            if (notify) {
                this.fireSeriesChanged();
            }
        }
    }

    public void fireSeriesChanged() {
        if (this.notify) {
            this.notifyListeners(new Series3DChangeEvent(this));
        }
    }

    protected void notifyListeners(Series3DChangeEvent event) {
        Object[] listenerList = this.listeners.getListenerList();
        for (int i = listenerList.length - 2; i >= 0; i -= 2) {
            if (listenerList[i] != Series3DChangeListener.class) continue;
            ((Series3DChangeListener)listenerList[i + 1]).seriesChanged(event);
        }
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof XYZSeries)) {
            return false;
        }
        XYZSeries that = (XYZSeries)obj;
        if (!this.key.equals(that.key)) {
            return false;
        }
        return this.items.equals(that.items);
    }

    public int hashCode() {
        int hash = 7;
        hash = 41 * hash + ObjectUtils.hashCode(this.key);
        return hash;
    }
}

