/*
 * Decompiled with CFR 0.152.
 */
package com.orsoncharts.fx;

import com.orsoncharts.Chart3D;
import com.orsoncharts.fx.Chart3DCanvas;
import com.orsoncharts.graphics3d.ExportUtils;
import com.orsoncharts.graphics3d.RenderedElement;
import com.orsoncharts.graphics3d.RenderingInfo;
import com.orsoncharts.graphics3d.ViewPoint3D;
import com.orsoncharts.interaction.fx.FXChart3DMouseEvent;
import com.orsoncharts.util.ArgChecks;
import com.orsoncharts.util.ExportFormats;
import java.io.File;
import java.io.IOException;
import javafx.event.Event;
import javafx.event.EventType;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Control;
import javafx.scene.control.Menu;
import javafx.scene.control.MenuItem;
import javafx.scene.control.SeparatorMenuItem;
import javafx.scene.control.Skinnable;
import javafx.scene.input.MouseEvent;
import javafx.stage.FileChooser;

public class Chart3DViewer
extends Control
implements Skinnable {
    private Chart3D chart;
    private Chart3DCanvas canvas;
    private ContextMenu contextMenu;
    private double zoomMultiplier = 0.95;

    public Chart3DViewer(Chart3D chart) {
        this(chart, true);
    }

    public Chart3DViewer(Chart3D chart, boolean contextMenuEnabled) {
        ArgChecks.nullNotPermitted(chart, "chart");
        this.chart = chart;
        this.getStyleClass().add((Object)"chart3d-control");
        this.contextMenu = this.createContextMenu();
        this.contextMenu.setOnShowing(event -> {
            Chart3DViewer viewer = this;
            if (viewer.canvas != null) {
                viewer.canvas.setRotateViewEnabled(false);
                viewer.canvas.setTooltipEnabled(false);
            }
        });
        this.contextMenu.setOnHiding(event -> {
            Chart3DViewer viewer = this;
            if (viewer.canvas != null) {
                viewer.canvas.setRotateViewEnabled(true);
                viewer.canvas.setTooltipEnabled(true);
            }
        });
        this.setContextMenu(this.contextMenu);
    }

    public Chart3D getChart() {
        return this.chart;
    }

    public void setChart(Chart3D chart) {
        ArgChecks.nullNotPermitted(chart, "chart");
        this.chart = chart;
        this.canvas.setChart(chart);
    }

    public Chart3DCanvas getCanvas() {
        return this.canvas;
    }

    public void setCanvas(Chart3DCanvas canvas) {
        ArgChecks.nullNotPermitted(canvas, "canvas");
        this.canvas = canvas;
        this.canvas.addEventHandler(MouseEvent.MOUSE_CLICKED, event -> {
            RenderingInfo info = canvas.getRenderingInfo();
            RenderedElement element = info.findElementAt(event.getX(), event.getY());
            Chart3DViewer viewer = this;
            viewer.fireEvent(new FXChart3DMouseEvent((Object)viewer, (EventType<? extends Event>)FXChart3DMouseEvent.MOUSE_CLICKED, element, (MouseEvent)event));
        });
    }

    public double getZoomMultiplier() {
        return this.zoomMultiplier;
    }

    public void setZoomMultiplier(double multiplier) {
        this.zoomMultiplier = multiplier;
    }

    private ContextMenu createContextMenu() {
        ContextMenu menu = new ContextMenu();
        MenuItem zoomIn = new MenuItem("Zoom In");
        zoomIn.setOnAction(e -> this.handleZoom(this.zoomMultiplier));
        MenuItem zoomOut = new MenuItem("Zoom Out");
        zoomOut.setOnAction(e -> this.handleZoom(1.0 / this.zoomMultiplier));
        MenuItem zoomToFit = new MenuItem("Zoom To Fit");
        zoomToFit.setOnAction(e -> this.handleZoomToFit());
        SeparatorMenuItem separator = new SeparatorMenuItem();
        Menu export = new Menu("Export As");
        MenuItem pngItem = new MenuItem("PNG...");
        pngItem.setOnAction(e -> this.handleExportToPNG());
        export.getItems().add((Object)pngItem);
        MenuItem jpegItem = new MenuItem("JPEG...");
        jpegItem.setOnAction(e -> this.handleExportToJPEG());
        export.getItems().add((Object)jpegItem);
        if (ExportFormats.isOrsonPDFAvailable()) {
            MenuItem pdfItem = new MenuItem("PDF...");
            pdfItem.setOnAction(e -> this.handleExportToPDF());
            export.getItems().add((Object)pdfItem);
        }
        if (ExportFormats.isJFreeSVGAvailable()) {
            MenuItem svgItem = new MenuItem("SVG...");
            svgItem.setOnAction(e -> this.handleExportToSVG());
            export.getItems().add((Object)svgItem);
        }
        menu.getItems().addAll((Object[])new MenuItem[]{zoomIn, zoomOut, zoomToFit, separator, export});
        return menu;
    }

    private void handleZoom(double multiplier) {
        ViewPoint3D viewPt = this.chart.getViewPoint();
        double minDistance = this.canvas.getMinViewingDistance();
        double maxDistance = minDistance * this.canvas.getMaxViewingDistanceMultiplier();
        double valRho = Math.max(minDistance, Math.min(maxDistance, viewPt.getRho() * multiplier));
        viewPt.setRho(valRho);
        this.canvas.draw();
    }

    private void handleZoomToFit() {
        this.canvas.zoomToFit(this.canvas.getWidth(), this.canvas.getHeight());
    }

    private void handleExportToPDF() {
        FileChooser fileChooser = new FileChooser();
        fileChooser.setSelectedExtensionFilter(new FileChooser.ExtensionFilter("Portable Document Format (PDF)", new String[]{"pdf"}));
        fileChooser.setTitle("Export to PDF");
        File file = fileChooser.showSaveDialog(this.getScene().getWindow());
        if (file != null) {
            ExportUtils.writeAsPDF(this.chart, (int)this.getWidth(), (int)this.getHeight(), file);
        }
    }

    private void handleExportToSVG() {
        FileChooser fileChooser = new FileChooser();
        fileChooser.setTitle("Export to SVG");
        fileChooser.setSelectedExtensionFilter(new FileChooser.ExtensionFilter("Scalable Vector Graphics (SVG)", new String[]{"svg"}));
        File file = fileChooser.showSaveDialog(this.getScene().getWindow());
        if (file != null) {
            ExportUtils.writeAsSVG(this.chart, (int)this.getWidth(), (int)this.getHeight(), file);
        }
    }

    private void handleExportToPNG() {
        FileChooser fileChooser = new FileChooser();
        fileChooser.setTitle("Export to PNG");
        fileChooser.setSelectedExtensionFilter(new FileChooser.ExtensionFilter("Portable Network Graphics (PNG)", new String[]{"png"}));
        File file = fileChooser.showSaveDialog(this.getScene().getWindow());
        if (file != null) {
            try {
                ExportUtils.writeAsPNG(this.chart, (int)this.getWidth(), (int)this.getHeight(), file);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private void handleExportToJPEG() {
        FileChooser fileChooser = new FileChooser();
        fileChooser.setTitle("Export to JPEG");
        fileChooser.setSelectedExtensionFilter(new FileChooser.ExtensionFilter("JPEG", new String[]{"jpg"}));
        File file = fileChooser.showSaveDialog(this.getScene().getWindow());
        if (file != null) {
            try {
                ExportUtils.writeAsJPEG(this.chart, (int)this.getWidth(), (int)this.getHeight(), file);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public String getUserAgentStylesheet() {
        return Chart3DViewer.class.getResource("chart3d-viewer.css").toExternalForm();
    }
}

