/*
 * Decompiled with CFR 0.152.
 */
package com.orsoncharts.renderer.category;

import com.orsoncharts.Range;
import com.orsoncharts.data.DataUtils;
import com.orsoncharts.data.KeyedValues3DItemKey;
import com.orsoncharts.data.Values3D;
import com.orsoncharts.data.category.CategoryDataset3D;
import com.orsoncharts.graphics3d.Dimension3D;
import com.orsoncharts.graphics3d.Object3D;
import com.orsoncharts.graphics3d.Offset3D;
import com.orsoncharts.graphics3d.World;
import com.orsoncharts.label.ItemLabelPositioning;
import com.orsoncharts.renderer.category.BarRenderer3D;

public class StackedBarRenderer3D
extends BarRenderer3D {
    public StackedBarRenderer3D() {
        this.setItemLabelPositioning(ItemLabelPositioning.FRONT_AND_BACK);
        this.setItemLabelOffsets(new Offset3D(0.0, 0.0, -1.0));
    }

    @Override
    public Range findValueRange(Values3D<? extends Number> data) {
        return DataUtils.findStackedValueRange(data);
    }

    @Override
    public void composeItem(CategoryDataset3D dataset, int series, int row, int column, World world, Dimension3D dimensions, double xOffset, double yOffset, double zOffset) {
        double value = dataset.getDoubleValue(series, row, column);
        if (Double.isNaN(value)) {
            return;
        }
        double[] stack = DataUtils.stackSubTotal(dataset, this.getBase(), series, row, column);
        double lower = stack[1];
        if (value < 0.0) {
            lower = stack[0];
        }
        double upper = lower + value;
        this.composeItem(upper, lower, dataset, series, row, column, world, dimensions, xOffset, yOffset, zOffset);
    }

    @Override
    protected void drawItemLabels(World world, CategoryDataset3D dataset, KeyedValues3DItemKey itemKey, double xw, double yw, double zw, double basew, boolean inverted) {
        String label;
        ItemLabelPositioning positioning = this.getItemLabelPositioning();
        if (this.getItemLabelGenerator() != null && (label = this.getItemLabelGenerator().generateItemLabel(dataset, (Comparable<?>)itemKey.getSeriesKey(), (Comparable<?>)itemKey.getRowKey(), (Comparable<?>)itemKey.getColumnKey())) != null) {
            Dimension3D dimensions = this.getPlot().getDimensions();
            double dx = this.getItemLabelOffsets().getDX();
            double dy = this.getItemLabelOffsets().getDY() * dimensions.getHeight();
            double dz = this.getItemLabelOffsets().getDZ() * this.getBarZWidth();
            if (positioning.equals((Object)ItemLabelPositioning.CENTRAL)) {
                double yy = yw;
                if (inverted) {
                    yy = basew;
                    dy = -dy;
                }
                Object3D labelObj = Object3D.createLabelObject(label, this.getItemLabelFont(), this.getItemLabelColor(), this.getItemLabelBackgroundColor(), xw + dx, yy + dy, zw, false, true);
                labelObj.setProperty("key", itemKey);
                world.add(labelObj);
            } else if (positioning.equals((Object)ItemLabelPositioning.FRONT_AND_BACK)) {
                double yy = (yw + basew) / 2.0;
                Object3D labelObj1 = Object3D.createLabelObject(label, this.getItemLabelFont(), this.getItemLabelColor(), this.getItemLabelBackgroundColor(), xw + dx, yy + dy, zw + dz, false, false);
                labelObj1.setProperty("key", itemKey);
                world.add(labelObj1);
                Object3D labelObj2 = Object3D.createLabelObject(label, this.getItemLabelFont(), this.getItemLabelColor(), this.getItemLabelBackgroundColor(), xw + dx, yy + dy, zw - dz, true, false);
                labelObj2.setProperty("key", itemKey);
                world.add(labelObj2);
            }
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof StackedBarRenderer3D)) {
            return false;
        }
        return super.equals(obj);
    }
}

