/*
 * Decompiled with CFR 0.152.
 */
package com.orsonpdf;

import com.orsonpdf.PDFObject;
import com.orsonpdf.PDFUtils;
import java.awt.geom.Rectangle2D;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class Dictionary {
    private String type;
    private Map map;

    public Dictionary() {
        this(null);
    }

    public Dictionary(String type) {
        this.type = type;
        this.map = new HashMap();
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    public int size() {
        return this.map.size();
    }

    public void put(String key, Object value) {
        this.map.put(key, value);
    }

    public Object remove(String key) {
        return this.map.remove(key);
    }

    public byte[] toPDFBytes() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            baos.write(PDFUtils.toBytes(this.toPDFString()));
        }
        catch (IOException ex) {
            throw new RuntimeException("Dictionary.toPDFBytes() failed.", ex);
        }
        return baos.toByteArray();
    }

    public String toPDFString() {
        StringBuilder b = new StringBuilder();
        b.append("<< ");
        if (this.type != null) {
            b.append("/Type ").append(this.type).append("\n");
        }
        for (Object key : this.map.keySet()) {
            int i;
            Object[] array;
            Object value = this.map.get(key);
            if (value instanceof Number || value instanceof String) {
                b.append(key.toString()).append(" ");
                b.append(value.toString()).append("\n");
                continue;
            }
            if (value instanceof PDFObject) {
                PDFObject pdfObj = (PDFObject)value;
                b.append(key.toString()).append(" ");
                b.append(pdfObj.getReference()).append("\n");
                continue;
            }
            if (value instanceof String[]) {
                b.append(key.toString()).append(" ");
                array = (String[])value;
                b.append("[");
                for (i = 0; i < array.length; ++i) {
                    if (i != 0) {
                        b.append(" ");
                    }
                    b.append((String)array[i]);
                }
                b.append("]\n");
                continue;
            }
            if (value instanceof PDFObject[]) {
                b.append(key.toString()).append(" ");
                array = (PDFObject[])value;
                b.append("[");
                for (i = 0; i < array.length; ++i) {
                    if (i != 0) {
                        b.append(" ");
                    }
                    b.append(((PDFObject)array[i]).getReference());
                }
                b.append("]\n");
                continue;
            }
            if (value instanceof Rectangle2D) {
                Rectangle2D r = (Rectangle2D)value;
                b.append(key.toString()).append(" ");
                b.append("[").append(r.getX()).append(" ");
                b.append(r.getY()).append(" ").append(r.getWidth()).append(" ");
                b.append(r.getHeight()).append("]\n");
                continue;
            }
            if (value instanceof Dictionary) {
                b.append(key.toString()).append(" ");
                Dictionary d = (Dictionary)value;
                b.append(d.toPDFString());
                continue;
            }
            if (value instanceof float[]) {
                b.append(key.toString()).append(" ");
                array = (float[])value;
                b.append("[");
                for (i = 0; i < array.length; ++i) {
                    if (i != 0) {
                        b.append(" ");
                    }
                    b.append((float)array[i]);
                }
                b.append("]\n");
                continue;
            }
            throw new RuntimeException("Unrecognised value type: " + value);
        }
        b.append(">>\n");
        return b.toString();
    }
}

