/*
 * Decompiled with CFR 0.152.
 */
package com.orsonpdf;

import com.orsonpdf.Dictionary;
import com.orsonpdf.ExponentialInterpolationFunction;
import com.orsonpdf.Function;
import com.orsonpdf.GraphicsStateDictionary;
import com.orsonpdf.GraphicsStream;
import com.orsonpdf.PDFDocument;
import com.orsonpdf.PDFFont;
import com.orsonpdf.PDFGraphics2D;
import com.orsonpdf.PDFImage;
import com.orsonpdf.PDFObject;
import com.orsonpdf.PDFSoftMaskImage;
import com.orsonpdf.Pages;
import com.orsonpdf.Pattern;
import com.orsonpdf.StitchingFunction;
import com.orsonpdf.filter.FlateFilter;
import com.orsonpdf.shading.AxialShading;
import com.orsonpdf.shading.RadialShading;
import com.orsonpdf.util.Args;
import com.orsonpdf.util.GradientPaintKey;
import com.orsonpdf.util.RadialGradientPaintKey;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Image;
import java.awt.MultipleGradientPaint;
import java.awt.RadialGradientPaint;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Page
extends PDFObject {
    private Pages parent;
    private Rectangle2D bounds;
    private GraphicsStream contents;
    private PDFGraphics2D graphics2d;
    private List<String> fontsOnPage;
    private Map<GradientPaintKey, String> gradientPaintsOnPage;
    private Map<RadialGradientPaintKey, String> radialGradientPaintsOnPage;
    private Dictionary patterns;
    private Dictionary graphicsStates;
    private AffineTransform j2DTransform;
    private Dictionary xObjects = new Dictionary();
    private Map<Integer, String> alphaDictionaries = new HashMap<Integer, String>();

    Page(int number, int generation, Pages parent, Rectangle2D bounds) {
        this(number, generation, parent, bounds, true);
    }

    Page(int number, int generation, Pages parent, Rectangle2D bounds, boolean filter) {
        super(number, generation);
        Args.nullNotPermitted(bounds, "bounds");
        this.parent = parent;
        this.bounds = (Rectangle2D)bounds.clone();
        this.fontsOnPage = new ArrayList<String>();
        int n = this.parent.getDocument().getNextNumber();
        this.contents = new GraphicsStream(n, this);
        if (filter) {
            this.contents.addFilter(new FlateFilter());
        }
        this.gradientPaintsOnPage = new HashMap<GradientPaintKey, String>();
        this.radialGradientPaintsOnPage = new HashMap<RadialGradientPaintKey, String>();
        this.patterns = new Dictionary();
        this.graphicsStates = new Dictionary();
        this.j2DTransform = AffineTransform.getTranslateInstance(0.0, bounds.getHeight());
        this.j2DTransform.concatenate(AffineTransform.getScaleInstance(1.0, -1.0));
    }

    public Rectangle2D getBounds() {
        return (Rectangle2D)this.bounds.clone();
    }

    public PDFObject getContents() {
        return this.contents;
    }

    public PDFGraphics2D getGraphics2D() {
        if (this.graphics2d == null) {
            this.graphics2d = new PDFGraphics2D(this.contents, (int)this.bounds.getWidth(), (int)this.bounds.getHeight());
        }
        return this.graphics2d;
    }

    String findOrCreateFontReference(Font font) {
        String ref = this.parent.findOrCreateFontReference(font);
        if (!this.fontsOnPage.contains(ref)) {
            this.fontsOnPage.add(ref);
        }
        return ref;
    }

    private Dictionary createFontDictionary() {
        Dictionary d = new Dictionary();
        for (String name : this.fontsOnPage) {
            PDFFont f = this.parent.getFont(name);
            d.put(name, f.getReference());
        }
        return d;
    }

    String findOrCreatePattern(GradientPaint gp) {
        GradientPaintKey key = new GradientPaintKey(gp);
        String patternName = this.gradientPaintsOnPage.get(key);
        if (patternName == null) {
            PDFDocument doc = this.parent.getDocument();
            ExponentialInterpolationFunction f = new ExponentialInterpolationFunction(doc.getNextNumber(), gp.getColor1().getRGBColorComponents(null), gp.getColor2().getRGBColorComponents(null));
            doc.addObject(f);
            double[] coords = new double[]{gp.getPoint1().getX(), gp.getPoint1().getY(), gp.getPoint2().getX(), gp.getPoint2().getY()};
            AxialShading s = new AxialShading(doc.getNextNumber(), coords, f);
            doc.addObject(s);
            Pattern.ShadingPattern p = new Pattern.ShadingPattern(doc.getNextNumber(), s, this.j2DTransform);
            doc.addObject(p);
            patternName = "/P" + (this.patterns.size() + 1);
            this.patterns.put(patternName, p);
            this.gradientPaintsOnPage.put(key, patternName);
        }
        return patternName;
    }

    String findOrCreatePattern(RadialGradientPaint gp) {
        RadialGradientPaintKey key = new RadialGradientPaintKey(gp);
        String patternName = this.radialGradientPaintsOnPage.get(key);
        if (patternName == null) {
            PDFDocument doc = this.parent.getDocument();
            Function f = this.createFunctionForMultipleGradient(gp);
            doc.addObject(f);
            double[] coords = new double[]{gp.getFocusPoint().getX(), gp.getFocusPoint().getY(), 0.0, gp.getCenterPoint().getX(), gp.getCenterPoint().getY(), gp.getRadius()};
            RadialShading s = new RadialShading(doc.getNextNumber(), coords, f);
            doc.addObject(s);
            Pattern.ShadingPattern p = new Pattern.ShadingPattern(doc.getNextNumber(), s, this.j2DTransform);
            doc.addObject(p);
            patternName = "/P" + (this.patterns.size() + 1);
            this.patterns.put(patternName, p);
            this.radialGradientPaintsOnPage.put(key, patternName);
        }
        return patternName;
    }

    private Function createFunctionForMultipleGradient(MultipleGradientPaint mgp) {
        PDFDocument doc = this.parent.getDocument();
        if (mgp.getColors().length == 2) {
            ExponentialInterpolationFunction f = new ExponentialInterpolationFunction(doc.getNextNumber(), mgp.getColors()[0].getRGBColorComponents(null), mgp.getColors()[1].getRGBColorComponents(null));
            return f;
        }
        int count = mgp.getColors().length - 1;
        Function[] functions = new Function[count];
        float[] fbounds = new float[count - 1];
        float[] encode = new float[count * 2];
        for (int i = 0; i < count; ++i) {
            functions[i] = new ExponentialInterpolationFunction(doc.getNextNumber(), mgp.getColors()[i].getRGBColorComponents(null), mgp.getColors()[i + 1].getRGBColorComponents(null));
            doc.addObject(functions[i]);
            if (i < count - 1) {
                fbounds[i] = mgp.getFractions()[i + 1];
            }
            encode[i * 2] = 0.0f;
            encode[i * 2 + 1] = 1.0f;
        }
        return new StitchingFunction(doc.getNextNumber(), functions, fbounds, encode);
    }

    String findOrCreateGSDictionary(int alpha) {
        Integer key = alpha;
        float alphaValue = (float)alpha / 255.0f;
        String name = this.alphaDictionaries.get(key);
        if (name == null) {
            PDFDocument pdfDoc = this.parent.getDocument();
            GraphicsStateDictionary gsd = new GraphicsStateDictionary(pdfDoc.getNextNumber());
            gsd.setNonStrokeAlpha(alphaValue);
            gsd.setStrokeAlpha(alphaValue);
            pdfDoc.addObject(gsd);
            name = "/GS" + (this.graphicsStates.size() + 1);
            this.graphicsStates.put(name, gsd);
            this.alphaDictionaries.put(key, name);
        }
        return name;
    }

    String addSoftMaskImage(Image img) {
        Args.nullNotPermitted(img, "img");
        PDFDocument pdfDoc = this.parent.getDocument();
        PDFSoftMaskImage softMaskImage = new PDFSoftMaskImage(pdfDoc.getNextNumber(), img);
        softMaskImage.addFilter(new FlateFilter());
        pdfDoc.addObject(softMaskImage);
        String reference = "/Image" + this.xObjects.size();
        this.xObjects.put(reference, softMaskImage);
        return softMaskImage.getReference();
    }

    String addImage(Image img, boolean addSoftMaskImage) {
        Args.nullNotPermitted(img, "img");
        PDFDocument pdfDoc = this.parent.getDocument();
        String softMaskImageRef = null;
        if (addSoftMaskImage) {
            softMaskImageRef = this.addSoftMaskImage(img);
        }
        PDFImage image = new PDFImage(pdfDoc.getNextNumber(), img, softMaskImageRef);
        image.addFilter(new FlateFilter());
        pdfDoc.addObject(image);
        String reference = "/Image" + this.xObjects.size();
        this.xObjects.put(reference, image);
        return reference;
    }

    @Override
    public byte[] getObjectBytes() {
        return this.createDictionary().toPDFBytes();
    }

    private Dictionary createDictionary() {
        Dictionary dictionary = new Dictionary("/Page");
        dictionary.put("/Parent", this.parent);
        dictionary.put("/MediaBox", this.bounds);
        dictionary.put("/Contents", this.contents);
        Dictionary resources = new Dictionary();
        resources.put("/ProcSet", "[/PDF /Text /ImageB /ImageC /ImageI]");
        if (!this.xObjects.isEmpty()) {
            resources.put("/XObject", this.xObjects);
        }
        if (!this.fontsOnPage.isEmpty()) {
            resources.put("/Font", this.createFontDictionary());
        }
        if (!this.patterns.isEmpty()) {
            resources.put("/Pattern", this.patterns);
        }
        if (!this.graphicsStates.isEmpty()) {
            resources.put("/ExtGState", this.graphicsStates);
        }
        dictionary.put("/Resources", resources);
        return dictionary;
    }
}

