/*
  Copyright (c) 2016-2024, Smart Engines Service LLC
  All rights reserved.
*/

#ifndef OBJCSECOMMON_IMPL_SE_SERIALIZATION_H_INCLUDED
#define OBJCSECOMMON_IMPL_SE_SERIALIZATION_H_INCLUDED

#import <se_serialization.h>

#include <se_serialization_common.h>

#include <memory>

@interface SECommonSerializationParameters (Internal)

- (instancetype) initFromInternalSerializationParameters:(const se::common::SerializationParameters &)params;
- (const se::common::SerializationParameters &) getInternalSerializationParameters;

@end


@interface SECommonSerializer (Internal)

- (instancetype) initFromCreatedInternalPointer:(se::common::Serializer *)serializer;
- (se::common::Serializer &) getInternalSerializer;

@end

#endif // OBJCSECOMMON_IMPL_SE_SERIALIZATION_H_INCLUDED