/*
  Copyright (c) 2016-2024, Smart Engines Service LLC
  All rights reserved.
*/

#ifndef OBJCIDENGINE_IMPL_ID_FACE_RESULT_H_INCLUDED
#define OBJCIDENGINE_IMPL_ID_FACE_RESULT_H_INCLUDED

#import <id_face_result.h>

#include <id_face_result_idengine.h>

@interface SEIdFaceDescriptionRef (Internal)

- (instancetype) initFromInternalFaceDescriptionPointer:(se::id::IdFaceDescription*)descptr
                                     withMutabilityFlag:(BOOL)mutabilityFlag;
- (se::id::IdFaceDescription *) getInternalFaceDescriptionPointer;

@end

@interface SEIdFaceDescription (Internal)

- (instancetype) initFromCreatedFaceDescription:(se::id::IdFaceDescription *)descptr;
- (const se::id::IdFaceDescription &) getInternalFaceDescription;

@end


@interface SEIdFaceLivenessResultRef (Internal)

- (instancetype) initFromInternalFaceLivenessResultPointer:(se::id::IdFaceLivenessResult *)resptr
                                        withMutabilityFlag:(BOOL)mutabilityFlag;
- (se::id::IdFaceLivenessResult *) getInternalFaceLivenessResultPointer;

@end

@interface SEIdFaceLivenessResult (Internal)

- (instancetype) initFromInternalFaceLivenessResult:(const se::id::IdFaceLivenessResult &)res;
- (const se::id::IdFaceLivenessResult &) getInternalFaceLivenessResult;

@end


@interface SEIdFaceSimilarityResultRef (Internal)

- (instancetype) initFromInternalFaceSimilarityResultPointer:(se::id::IdFaceSimilarityResult *)resptr
                                          withMutabilityFlag:(BOOL)mutabilityFlag;
- (se::id::IdFaceSimilarityResult *) getInternalFaceSimilarityResultPointer;

@end

@interface SEIdFaceSimilarityResult (Internal)

- (instancetype) initFromInternalFaceSimilarityResult:(const se::id::IdFaceSimilarityResult &)res;
- (const se::id::IdFaceSimilarityResult &) getInternalFaceSimilarityResult;

@end

#endif // OBJCIDENGINE_IMPL_ID_FACE_RESULT_H_INCLUDED
