# 1. Create a .bitrise.secrets.yml file in bitrise_deployment directory
# 2. Add the following keys:
# envs:
# - BITRISE_DEPLOY_DIR: /Users/Viktas/Downloads/DEPLOY_DIR (zip file will be created here)
# - PROJECT_DIR: /Users/Viktas/Documents/ivs_ios (project directory)
# 3. Open terminal, cd bitrise_deployment directory
# 4. Run "bitrise run deploy" command in terminal

cd $PROJECT_DIR

# Create Frameworks
xcodebuild -workspace idenfySdk.xcworkspace -scheme iDenfyInternalLogger -configuration Release -derivedDataPath $BITRISE_DEPLOY_DIR/devices -sdk iphoneos ONLY_ACTIVE_ARCH=NO ENABLE_BITCODE=NO BITCODE_GENERATION_MODE=bitcode SWIFT_ACTIVE_COMPILATION_CONDITIONS="" OTHER_CFLAGS="-fembed-bitcode" clean archive

xcodebuild -workspace idenfySdk.xcworkspace -scheme iDenfyInternalLogger -configuration Release -derivedDataPath $BITRISE_DEPLOY_DIR/simulators -sdk iphonesimulator ONLY_ACTIVE_ARCH=NO ENABLE_BITCODE=NO BITCODE_GENERATION_MODE=bitcode SWIFT_ACTIVE_COMPILATION_CONDITIONS="" OTHER_CFLAGS="-fembed-bitcode" clean archive

xcodebuild -workspace idenfySdk.xcworkspace -scheme iDenfyDocRecognition -configuration Release -derivedDataPath $BITRISE_DEPLOY_DIR/devices -sdk iphoneos ONLY_ACTIVE_ARCH=NO ENABLE_BITCODE=NO BITCODE_GENERATION_MODE=bitcode SWIFT_ACTIVE_COMPILATION_CONDITIONS="IDENFY_RECOGNITION" OTHER_CFLAGS="-fembed-bitcode" clean archive

xcodebuild -workspace idenfySdk.xcworkspace -scheme iDenfyDocRecognition -configuration Release -derivedDataPath $BITRISE_DEPLOY_DIR/simulators -sdk iphonesimulator ONLY_ACTIVE_ARCH=NO EXCLUDED_ARCHS=i386 ENABLE_BITCODE=NO BITCODE_GENERATION_MODE=bitcode SWIFT_ACTIVE_COMPILATION_CONDITIONS="IDENFY_RECOGNITION" OTHER_CFLAGS="-fembed-bitcode" clean archive

xcodebuild -workspace idenfySdk.xcworkspace -scheme idenfyviews -configuration Release -derivedDataPath $BITRISE_DEPLOY_DIR/devices -sdk iphoneos ONLY_ACTIVE_ARCH=NO ENABLE_BITCODE=NO BITCODE_GENERATION_MODE=bitcode SWIFT_ACTIVE_COMPILATION_CONDITIONS="" OTHER_CFLAGS="-fembed-bitcode" clean archive

xcodebuild -workspace idenfySdk.xcworkspace -scheme idenfyviews -configuration Release -derivedDataPath $BITRISE_DEPLOY_DIR/simulators -sdk iphonesimulator ONLY_ACTIVE_ARCH=NO ENABLE_BITCODE=NO BITCODE_GENERATION_MODE=bitcode SWIFT_ACTIVE_COMPILATION_CONDITIONS="" OTHER_CFLAGS="-fembed-bitcode" clean archive

xcodebuild -workspace idenfySdk.xcworkspace -scheme idenfycore -configuration Release -derivedDataPath $BITRISE_DEPLOY_DIR/devices -sdk iphoneos ONLY_ACTIVE_ARCH=NO ENABLE_BITCODE=NO BITCODE_GENERATION_MODE=bitcode SWIFT_ACTIVE_COMPILATION_CONDITIONS="" OTHER_CFLAGS="-fembed-bitcode" clean archive

xcodebuild -workspace idenfySdk.xcworkspace -scheme idenfycore -configuration Release -derivedDataPath $BITRISE_DEPLOY_DIR/simulators -sdk iphonesimulator ONLY_ACTIVE_ARCH=NO ENABLE_BITCODE=NO BITCODE_GENERATION_MODE=bitcode SWIFT_ACTIVE_COMPILATION_CONDITIONS="" OTHER_CFLAGS="-fembed-bitcode" clean archive

xcodebuild -workspace idenfySdk.xcworkspace -scheme idenfyNFCReading -configuration Release -derivedDataPath $BITRISE_DEPLOY_DIR/devices -sdk iphoneos ONLY_ACTIVE_ARCH=NO ENABLE_BITCODE=NO BITCODE_GENERATION_MODE=bitcode SWIFT_ACTIVE_COMPILATION_CONDITIONS="" OTHER_CFLAGS="-fembed-bitcode" clean archive

xcodebuild -workspace idenfySdk.xcworkspace -scheme idenfyNFCReading -configuration Release -derivedDataPath $BITRISE_DEPLOY_DIR/simulators -sdk iphonesimulator ONLY_ACTIVE_ARCH=NO ENABLE_BITCODE=NO BITCODE_GENERATION_MODE=bitcode SWIFT_ACTIVE_COMPILATION_CONDITIONS="" OTHER_CFLAGS="-fembed-bitcode" clean archive

xcodebuild -workspace idenfySdk.xcworkspace -scheme IdenfyLiveness -configuration Release -derivedDataPath $BITRISE_DEPLOY_DIR/devices -sdk iphoneos ONLY_ACTIVE_ARCH=NO ENABLE_BITCODE=NO BITCODE_GENERATION_MODE=bitcode SWIFT_ACTIVE_COMPILATION_CONDITIONS="" OTHER_CFLAGS="-fembed-bitcode" clean archive

xcodebuild -workspace idenfySdk.xcworkspace -scheme IdenfyLiveness -configuration Release -derivedDataPath $BITRISE_DEPLOY_DIR/simulators -sdk iphonesimulator ONLY_ACTIVE_ARCH=NO ENABLE_BITCODE=NO BITCODE_GENERATION_MODE=bitcode SWIFT_ACTIVE_COMPILATION_CONDITIONS="" OTHER_CFLAGS="-fembed-bitcode" clean archive

xcodebuild -workspace idenfySdk.xcworkspace -scheme IdenfySDK -configuration Release -derivedDataPath $BITRISE_DEPLOY_DIR/devices -sdk iphoneos ONLY_ACTIVE_ARCH=NO ENABLE_BITCODE=NO BITCODE_GENERATION_MODE=bitcode SWIFT_ACTIVE_COMPILATION_CONDITIONS="" OTHER_CFLAGS="-fembed-bitcode" clean archive

xcodebuild -workspace idenfySdk.xcworkspace -scheme IdenfySDK -configuration Release -derivedDataPath $BITRISE_DEPLOY_DIR/simulators -sdk iphonesimulator ENABLE_BITCODE=NO BITCODE_GENERATION_MODE=bitcode ONLY_ACTIVE_ARCH=NO SWIFT_ACTIVE_COMPILATION_CONDITIONS="" OTHER_CFLAGS="-fembed-bitcode" clean archive

xcodebuild -workspace idenfySdk.xcworkspace -scheme IdenfySDK -configuration Release -derivedDataPath $BITRISE_DEPLOY_DIR/devices/liveness -sdk iphoneos ENABLE_BITCODE=NO BITCODE_GENERATION_MODE=bitcode ONLY_ACTIVE_ARCH=NO SWIFT_ACTIVE_COMPILATION_CONDITIONS=IDENFY_LIVELINESS OTHER_CFLAGS="-fembed-bitcode" clean archive

xcodebuild -workspace idenfySdk.xcworkspace -scheme IdenfySDK -configuration Release -derivedDataPath $BITRISE_DEPLOY_DIR/simulators/liveness -sdk iphonesimulator ENABLE_BITCODE=NO BITCODE_GENERATION_MODE=bitcode ONLY_ACTIVE_ARCH=NO SWIFT_ACTIVE_COMPILATION_CONDITIONS=IDENFY_LIVELINESS OTHER_CFLAGS="-fembed-bitcode" clean archive

xcodebuild -workspace idenfySdk.xcworkspace -scheme IdenfySDK -configuration Release -derivedDataPath $BITRISE_DEPLOY_DIR/devices/recognition -sdk iphoneos ENABLE_BITCODE=NO BITCODE_GENERATION_MODE=bitcode ONLY_ACTIVE_ARCH=NO SWIFT_ACTIVE_COMPILATION_CONDITIONS="IDENFY_LIVELINESS IDENFY_RECOGNITION" OTHER_CFLAGS="-fembed-bitcode" clean archive

xcodebuild -workspace idenfySdk.xcworkspace -scheme IdenfySDK -configuration Release -derivedDataPath $BITRISE_DEPLOY_DIR/simulators/recognition -sdk iphonesimulator EXCLUDED_ARCHS=i386 ENABLE_BITCODE=NO BITCODE_GENERATION_MODE=bitcode ONLY_ACTIVE_ARCH=NO SWIFT_ACTIVE_COMPILATION_CONDITIONS="IDENFY_LIVELINESS IDENFY_RECOGNITION" OTHER_CFLAGS="-fembed-bitcode" clean archive

xcodebuild -create-xcframework \
    -framework $BITRISE_DEPLOY_DIR/devices/Build/Intermediates.noindex/ArchiveIntermediates/IdenfySDK/IntermediateBuildFilesPath/UninstalledProducts/iphoneos/iDenfyInternalLogger.framework \
   -framework $BITRISE_DEPLOY_DIR/simulators/Build/Intermediates.noindex/ArchiveIntermediates/IdenfySDK/IntermediateBuildFilesPath/UninstalledProducts/iphonesimulator/iDenfyInternalLogger.framework \
  -output $BITRISE_DEPLOY_DIR/output/iDenfyInternalLogger.xcframework
  
xcodebuild -create-xcframework \
    -framework $BITRISE_DEPLOY_DIR/devices/Build/Intermediates.noindex/ArchiveIntermediates/IdenfySDK/IntermediateBuildFilesPath/UninstalledProducts/iphoneos/iDenfyDocRecognition.framework \
   -framework $BITRISE_DEPLOY_DIR/simulators/Build/Intermediates.noindex/ArchiveIntermediates/IdenfySDK/IntermediateBuildFilesPath/UninstalledProducts/iphonesimulator/iDenfyDocRecognition.framework \
  -output $BITRISE_DEPLOY_DIR/output/iDenfyDocRecognition.xcframework

xcodebuild -create-xcframework \
    -framework $BITRISE_DEPLOY_DIR/devices/Build/Intermediates.noindex/ArchiveIntermediates/IdenfySDK/IntermediateBuildFilesPath/UninstalledProducts/iphoneos/idenfyviews.framework \
   -framework $BITRISE_DEPLOY_DIR/simulators/Build/Intermediates.noindex/ArchiveIntermediates/IdenfySDK/IntermediateBuildFilesPath/UninstalledProducts/iphonesimulator/idenfyviews.framework \
  -output $BITRISE_DEPLOY_DIR/output/idenfyviews.xcframework

xcodebuild -create-xcframework \
    -framework $BITRISE_DEPLOY_DIR/devices/Build/Intermediates.noindex/ArchiveIntermediates/IdenfySDK/IntermediateBuildFilesPath/UninstalledProducts/iphoneos/IdenfyLiveness.framework \
   -framework $BITRISE_DEPLOY_DIR/simulators/Build/Intermediates.noindex/ArchiveIntermediates/IdenfySDK/IntermediateBuildFilesPath/UninstalledProducts/iphonesimulator/IdenfyLiveness.framework \
  -output $BITRISE_DEPLOY_DIR/output/IdenfyLiveness.xcframework

xcodebuild -create-xcframework \
    -framework $BITRISE_DEPLOY_DIR/devices/Build/Intermediates.noindex/ArchiveIntermediates/IdenfySDK/IntermediateBuildFilesPath/UninstalledProducts/iphoneos/idenfycore.framework \
   -framework $BITRISE_DEPLOY_DIR/simulators/Build/Intermediates.noindex/ArchiveIntermediates/IdenfySDK/IntermediateBuildFilesPath/UninstalledProducts/iphonesimulator/idenfycore.framework \
  -output $BITRISE_DEPLOY_DIR/output/idenfycore.xcframework

xcodebuild -create-xcframework \
    -framework $BITRISE_DEPLOY_DIR/devices/Build/Intermediates.noindex/ArchiveIntermediates/IdenfySDK/IntermediateBuildFilesPath/UninstalledProducts/iphoneos/idenfyNFCReading.framework \
   -framework $BITRISE_DEPLOY_DIR/simulators/Build/Intermediates.noindex/ArchiveIntermediates/IdenfySDK/IntermediateBuildFilesPath/UninstalledProducts/iphonesimulator/idenfyNFCReading.framework \
  -output $BITRISE_DEPLOY_DIR/output/idenfyNFCReading.xcframework

xcodebuild -create-xcframework \
    -framework $BITRISE_DEPLOY_DIR/devices/Build/Intermediates.noindex/ArchiveIntermediates/IdenfySDK/IntermediateBuildFilesPath/UninstalledProducts/iphoneos/iDenfySDK.framework \
   -framework $BITRISE_DEPLOY_DIR/simulators/Build/Intermediates.noindex/ArchiveIntermediates/IdenfySDK/IntermediateBuildFilesPath/UninstalledProducts/iphonesimulator/iDenfySDK.framework \
  -output $BITRISE_DEPLOY_DIR/output/iDenfySDK.xcframework
  
xcodebuild -create-xcframework \
    -framework $BITRISE_DEPLOY_DIR/devices/liveness/Build/Intermediates.noindex/ArchiveIntermediates/IdenfySDK/IntermediateBuildFilesPath/UninstalledProducts/iphoneos/iDenfySDK.framework \
   -framework $BITRISE_DEPLOY_DIR/simulators/liveness/Build/Intermediates.noindex/ArchiveIntermediates/IdenfySDK/IntermediateBuildFilesPath/UninstalledProducts/iphonesimulator/iDenfySDK.framework \
  -output $BITRISE_DEPLOY_DIR/output/liveness/iDenfySDK.xcframework
  
  xcodebuild -create-xcframework \
    -framework $BITRISE_DEPLOY_DIR/devices/recognition/Build/Intermediates.noindex/ArchiveIntermediates/IdenfySDK/IntermediateBuildFilesPath/UninstalledProducts/iphoneos/iDenfySDK.framework \
   -framework $BITRISE_DEPLOY_DIR/simulators/recognition/Build/Intermediates.noindex/ArchiveIntermediates/IdenfySDK/IntermediateBuildFilesPath/UninstalledProducts/iphonesimulator/iDenfySDK.framework \
  -output $BITRISE_DEPLOY_DIR/output/recognition/iDenfySDK.xcframework

# Create structure
cp -R $PROJECT_DIR/FaceTecSDK.xcframework $BITRISE_DEPLOY_DIR/output
cp -R $PROJECT_DIR/iDenfyDocRecognition/documentrecognition/idengine.xcframework $BITRISE_DEPLOY_DIR/output
cp -R $PROJECT_DIR/OpenSSL.xcframework $BITRISE_DEPLOY_DIR/output
mkdir $BITRISE_DEPLOY_DIR/output/IdenfyAssets
cp -R $PROJECT_DIR/iDenfySDK/idenfyassets/strings $BITRISE_DEPLOY_DIR/output/IdenfyAssets
mkdir $BITRISE_DEPLOY_DIR/output/IdenfyAssets/V2
cp -R $PROJECT_DIR/idenfyviews/assets $BITRISE_DEPLOY_DIR/output/IdenfyAssets/V2
mv $BITRISE_DEPLOY_DIR/output/IdenfyAssets/strings $BITRISE_DEPLOY_DIR/output/IdenfyAssets/IdenfyStrings
mkdir $BITRISE_DEPLOY_DIR/SDK
cp -R $BITRISE_DEPLOY_DIR/output/IdenfyAssets $BITRISE_DEPLOY_DIR/SDK
mkdir $BITRISE_DEPLOY_DIR/SDK/IdenfySDK
cp -R $BITRISE_DEPLOY_DIR/output/iDenfySDK.xcframework $BITRISE_DEPLOY_DIR/SDK/IdenfySDK
cp -R $BITRISE_DEPLOY_DIR/output/idenfycore.xcframework $BITRISE_DEPLOY_DIR/SDK/IdenfySDK
cp -R $BITRISE_DEPLOY_DIR/output/idenfyviews.xcframework $BITRISE_DEPLOY_DIR/SDK/IdenfySDK
cp -R $BITRISE_DEPLOY_DIR/output/idenfyNFCReading.xcframework $BITRISE_DEPLOY_DIR/SDK/IdenfySDK
cp -R $BITRISE_DEPLOY_DIR/output/iDenfyInternalLogger.xcframework $BITRISE_DEPLOY_DIR/SDK/IdenfySDK
cp -R $BITRISE_DEPLOY_DIR/output/OpenSSL.xcframework $BITRISE_DEPLOY_DIR/SDK/IdenfySDK
mkdir $BITRISE_DEPLOY_DIR/SDK/IdenfyLiveness
cp -R $BITRISE_DEPLOY_DIR/output/IdenfyLiveness.xcframework $BITRISE_DEPLOY_DIR/SDK/IdenfyLiveness
cp -R $BITRISE_DEPLOY_DIR/output/idenfycore.xcframework $BITRISE_DEPLOY_DIR/SDK/IdenfyLiveness
cp -R $BITRISE_DEPLOY_DIR/output/idenfyviews.xcframework $BITRISE_DEPLOY_DIR/SDK/IdenfyLiveness
cp -R $BITRISE_DEPLOY_DIR/output/idenfyNFCReading.xcframework $BITRISE_DEPLOY_DIR/SDK/IdenfyLiveness
cp -R $BITRISE_DEPLOY_DIR/output/FaceTecSDK.xcframework $BITRISE_DEPLOY_DIR/SDK/IdenfyLiveness
cp -R $BITRISE_DEPLOY_DIR/output/OpenSSL.xcframework $BITRISE_DEPLOY_DIR/SDK/IdenfyLiveness
cp -R $BITRISE_DEPLOY_DIR/output/iDenfyInternalLogger.xcframework $BITRISE_DEPLOY_DIR/SDK/IdenfyLiveness
cp -R $BITRISE_DEPLOY_DIR/output/liveness/iDenfySDK.xcframework $BITRISE_DEPLOY_DIR/SDK/IdenfyLiveness
mkdir $BITRISE_DEPLOY_DIR/SDK/IdenfyRecognition
cp -R $BITRISE_DEPLOY_DIR/output/iDenfyDocRecognition.xcframework $BITRISE_DEPLOY_DIR/SDK/IdenfyRecognition
cp -R $BITRISE_DEPLOY_DIR/output/IdenfyLiveness.xcframework $BITRISE_DEPLOY_DIR/SDK/IdenfyRecognition
cp -R $BITRISE_DEPLOY_DIR/output/idenfycore.xcframework $BITRISE_DEPLOY_DIR/SDK/IdenfyRecognition
cp -R $BITRISE_DEPLOY_DIR/output/idenfyviews.xcframework $BITRISE_DEPLOY_DIR/SDK/IdenfyRecognition
cp -R $BITRISE_DEPLOY_DIR/output/idenfyNFCReading.xcframework $BITRISE_DEPLOY_DIR/SDK/IdenfyRecognition
cp -R $BITRISE_DEPLOY_DIR/output/FaceTecSDK.xcframework $BITRISE_DEPLOY_DIR/SDK/IdenfyRecognition
cp -R $BITRISE_DEPLOY_DIR/output/OpenSSL.xcframework $BITRISE_DEPLOY_DIR/SDK/IdenfyRecognition
cp -R $BITRISE_DEPLOY_DIR/output/iDenfyInternalLogger.xcframework $BITRISE_DEPLOY_DIR/SDK/IdenfyRecognition
cp -R $BITRISE_DEPLOY_DIR/output/recognition/iDenfySDK.xcframework $BITRISE_DEPLOY_DIR/SDK/IdenfyRecognition
cp -R $BITRISE_DEPLOY_DIR/output/idengine.xcframework $BITRISE_DEPLOY_DIR/SDK/IdenfyRecognition

# Zip the directory
cd $BITRISE_DEPLOY_DIR/SDK
zip -r $BITRISE_DEPLOY_DIR/SDK *
mv $BITRISE_DEPLOY_DIR/SDK.zip $BITRISE_DEPLOY_DIR/iDenfySDKxcf.zip

rm -rf $BITRISE_DEPLOY_DIR/simulators
rm -rf $BITRISE_DEPLOY_DIR/devices
rm -rf $BITRISE_DEPLOY_DIR/output
rm -rf $BITRISE_DEPLOY_DIR/SDK
echo Setup is Done!
