/*
  Copyright (c) 2016-2024, Smart Engines Service LLC
  All rights reserved.
*/

#ifndef OBJCIDENGINE_ID_FACE_SESSION_H_INCLUDED
#define OBJCIDENGINE_ID_FACE_SESSION_H_INCLUDED

#import <Foundation/Foundation.h>

#import "id_face_result.h"

#import "se_image.h"

@interface SEIdFaceSession : NSObject

- (nonnull NSString *) getActivationRequest;
- (void) activate:(nonnull NSString *)activation_response;

- (BOOL) isActivated;

- (nonnull SEIdFaceDescription *) getFaceDescriptionForFaceImage:(nonnull SECommonImageRef *)face_image;
- (nonnull SEIdFaceSimilarityResult *) getSimilarityBetweenFaceImage:(nonnull SECommonImageRef *)face_image_a
                                                        andFaceImage:(nonnull SECommonImageRef *)face_image_b;
- (nonnull SEIdFaceSimilarityResult *) getSimilarityBetweenFaceDescription:(nonnull SEIdFaceDescriptionRef *)face_description_a
                                                        andFaceDescription:(nonnull SEIdFaceDescriptionRef *)face_description_b;

- (void) addFaceImage:(nonnull SECommonImageRef *)face_image;
- (void) addFaceDescription:(nonnull SEIdFaceDescriptionRef *)face_description;

- (nonnull SEIdFaceDescriptionRef *) getAccumulatedFaceDescription;


- (nonnull SEIdFaceSimilarityResult *) getSimilarityWithFaceImage:(nonnull SECommonImageRef *)compare_image;
- (nonnull SEIdFaceSimilarityResult *) getSimilarityWithFaceDescription:(nonnull SEIdFaceDescriptionRef *)compare_description;

- (nonnull SEIdFaceLivenessResult *) getLivenessResult;

- (void) reset;

@end

#endif // OBJCIDENGINE_ID_FACE_SESSION_H_INCLUDED