/*
  Copyright (c) 2016-2024, Smart Engines Service LLC
  All rights reserved.
*/

#ifndef OBJCIDENGINE_IMPL_ID_PROXY_H_INCLUDED
#define OBJCIDENGINE_IMPL_ID_PROXY_H_INCLUDED

#import <id_feedback_impl.h>
#import <id_result_impl.h>

#import <id_face_feedback.h>

#include <id_feedback_idengine.h>
#include <id_face_feedback_idengine.h>

class ProxyReporter : public se::id::IdFeedback {
public:
  ProxyReporter(id<SEIdFeedback> feedback_reporter);

  void setReporter(id<SEIdFeedback> feedback_reporter);

  virtual void FeedbackReceived(
      const se::id::IdFeedbackContainer& feedback_container) override final;

  virtual void TemplateDetectionResultReceived(
      const se::id::IdTemplateDetectionResult& detection_result) override final;

  virtual void TemplateSegmentationResultReceived(
      const se::id::IdTemplateSegmentationResult& segmentation_result) override final;

  virtual void ResultReceived(const se::id::IdResult& result) override final;

  virtual void SessionEnded() override final;

private:
  void recalculateCache();

  id<SEIdFeedback> feedbackReporter_; // should be weak, no refcounts

  bool responds_to_feedback_received = false;
  bool responds_to_template_detections = false;
  bool responds_to_template_segmentations = false;
  bool responds_to_results = false;
  bool responds_to_session_ended = false;
};

class ProxyFaceReporter : public se::id::IdFaceFeedback {
public:
  ProxyFaceReporter(id<SEIdFaceFeedback> feedback_reporter);

  void setReporter(id<SEIdFaceFeedback> feedback_reporter);

  virtual void MessageReceived(const char* message) override final;

private:
  void recalculateCache();

  id<SEIdFaceFeedback> feedbackReporter_; // should be weak, no refcounts

  bool responds_to_message_received = false;
};

#endif // OBJCIDENGINE_IMPL_ID_PROXY_H_INCLUDED
