/*
  Copyright (c) 2016-2024, Smart Engines Service LLC
  All rights reserved.
*/

#ifndef OBJCIDENGINE_ID_FACE_RESULT_H_INCLUDED
#define OBJCIDENGINE_ID_FACE_RESULT_H_INCLUDED

#import <Foundation/Foundation.h>

#import "se_geometry.h"
#import "se_image.h"

typedef enum { 
  SEIdFaceOrientation_0,
  SEIdFaceOrientation_90CW,
  SEIdFaceOrientation_180,
  SEIdFaceOrientation_270CW
} SEIdFaceOrientation;

typedef enum { 
  SEIdFaceStatus_NotUsed,
  SEIdFaceStatus_Success,
  SEIdFaceStatus_A_FaceNotFound,
  SEIdFaceStatus_B_FaceNotFound,
  SEIdFaceStatus_FaceNotFound,
  SEIdFaceStatus_NoAccumulatedResult
} SEIdFaceStatus;


@class SEIdFaceDescription;

@interface SEIdFaceDescriptionRef : NSObject

- (BOOL) isMutable;

- (nonnull SEIdFaceDescription *) clone;

- (BOOL) faceDetected;

- (nonnull SECommonRectangle *) getRectangle;
- (void) setRectangleTo:(nonnull SECommonRectangle *)rect;

- (SEIdFaceOrientation) getOrientation;
- (void) setOrientationTo:(SEIdFaceOrientation)orientation;

- (BOOL) hasVisualizationImage;

- (nonnull SECommonImageRef *) getVisualizationImage;
- (nonnull SECommonImageRef *) getMutableVisualizationImage;
- (void) setVisualizationImageTo:(nonnull SECommonImageRef *)image;

- (int) getFeatureVectorSize;
- (float) getFeatureAt:(int)index;
- (void) setFeatureAt:(int)index
                   to:(float)value;
- (void) resizeFeatureVectorTo:(int)size;

@end

@interface SEIdFaceDescription : NSObject

- (nonnull instancetype) init;

- (nonnull SEIdFaceDescriptionRef *) getRef;
- (nonnull SEIdFaceDescriptionRef *) getMutableRef;

@end


@class SEIdFaceLivenessResult;

@interface SEIdFaceLivenessResultRef : NSObject

- (BOOL) isMutable;

- (nonnull SEIdFaceLivenessResult *) clone;

- (double) getLivenessEstimation;
- (void) setLivenessEstimationTo:(double)estimation;

- (nonnull NSString *) getLivenessInstruction;
- (void) setLivenessInstructionTo:(nonnull NSString *)instruction;

@end


@interface SEIdFaceLivenessResult : NSObject

- (nonnull instancetype) init;
- (nonnull instancetype) initWithLivenessEstimation:(double)estimation;

- (nonnull SEIdFaceLivenessResultRef *) getRef;
- (nonnull SEIdFaceLivenessResultRef *) getMutableRef;

@end


@class SEIdFaceSimilarityResult;

@interface SEIdFaceSimilarityResultRef : NSObject

- (BOOL) isMutable;

- (nonnull SEIdFaceSimilarityResult *) clone;

- (double) getSimilarityEstimation;
- (void) setSimilarityEstimationTo:(double)estimation;

- (SEIdFaceStatus) getStatus;
- (void) setStatus:(SEIdFaceStatus)status;

@end

@interface SEIdFaceSimilarityResult : NSObject
  
- (nonnull instancetype) init;
- (nonnull instancetype) initWithSimilarityEstimation:(double)estimation;
- (nonnull instancetype) initWithFaceStatus:(SEIdFaceStatus)status;
- (nonnull instancetype) initWithSimilarityEstimation:(double)estimation
                         withFaceStatus:(SEIdFaceStatus)status;

- (nonnull SEIdFaceSimilarityResultRef *) getRef;
- (nonnull SEIdFaceSimilarityResultRef *) getMutableRef;

@end

#endif // OBJCIDENGINE_ID_FACE_RESULT_H_INCLUDED