function varargout = Ex17i_IPMSM(varargin)
% EX17I_IPMSM M-file for Ex17i_IPMSM.fig
%      EX17I_IPMSM, by itself, creates a new EX17I_IPMSM or raises the existing
%      singleton*.
%
%      H = EX17I_IPMSM returns the handle to a new EX17I_IPMSM or the handle to
%      the existing singleton*.
%
%      EX17I_IPMSM('CALLBACK',hObject,eventData,handles,...) calls the local
%      function named CALLBACK outfname EX17I_IPMSM.M with the given input arguments.
%
%      EX17I_IPMSM('Property','Value',...) creates a new EX17I_IPMSM or raises the
%      existing singleton*.  Starting from the left, property value pairs are
%      applied to the GUI before Ex16i_PMSMbyGA_OpeningFunction gets called.  An
%      unrecognized property name or invalid value makes property application
%      stop.  All inputs are passed to Ex17i_IPMSM_OpeningFcn via varargin.
%
%      *See GUI Options on GUIDE's Tools menu.  Choose "GUI allows only one
%      instance to run (singleton)".
%
% See also: GUIDE, GUIDATA, GUIHANDLES

% Edit the above text to modify the response to help Ex17i_IPMSM

% Last Modified by GUIDE v2.5 24-Jan-2021 15:22:20

% Begin initialization code - DO NOT EDIT
gui_Singleton = 1;
gui_State = struct('gui_Name',       mfilename, ...
                   'gui_Singleton',  gui_Singleton, ...
                   'gui_OpeningFcn', @Ex17i_IPMSM_OpeningFcn, ...
                   'gui_OutputFcn',  @Ex17i_IPMSM_OutputFcn, ...
                   'gui_LayoutFcn',  [] , ...
                   'gui_Callback',   []);
if nargin && ischar(varargin{1})
    gui_State.gui_Callback = str2func(varargin{1});
end

if nargout
    [varargout{1:nargout}] = gui_mainfcn(gui_State, varargin{:});
else
    gui_mainfcn(gui_State, varargin{:});
end
% End initialization code - DO NOT EDIT

% --- Executes just before Ex17i_IPMSM is made visible.
function Ex17i_IPMSM_OpeningFcn(hObject, eventdata, handles, varargin)
% This function has no output args, see OutputFcn.
% hObject    handle to figure
% eventdata  reserved - to be defined outfname a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
% varargin   command line arguments to Ex17i_IPMSM (see VARARGIN)

% Choose default command line output for Ex17i_IPMSM
handles.output = hObject;

% Update handles structure
guidata(hObject, handles);
if nargin==4
    figNumber=varargin{1};
else
    figNumber=0;
end
if strcmp(get(hObject,'Visible'),'off')
    initialize_gui(hObject, handles,figNumber);
end
set(handles.figure1,'Name','PMSM Optimal design - GA');

% --- Outputs from this function are returned to the command line.
function varargout = Ex17i_IPMSM_OutputFcn(hObject, eventdata, handles)
varargout{1} = handles.output;

%-----------------------------------------------------------------------
%           ---  Input Parameters   ---
%-----------------------------------------------------------------------

function inFname_CreateFcn(hObject, eventdata, handles)
my_background(hObject);
function inFname_Callback(hObject, eventdata, handles)
din=getappdata(gcbf, 'metricdata');
din.fname=get(hObject, 'String');
setappdata(gcbf, 'metricdata', din);
OutputFileDispl(handles,din);

%------------------------------------------------------------
%           ---  Output results   ---
%------------------------------------------------------------

function outFname_CreateFcn(hObject, eventdata, handles)
my_background(hObject);


%------------------------------------------------------------
%           ---  Push button actions   ---
%------------------------------------------------------------

% --- Executes on button press outfname pushbutton1.
function pushbutton1_Callback(hObject, eventdata, handles)
set(handles.text5,'String','Please wait design results!')
set(handles.frame2,'BackgroundColor',[1 0 0]);
din = getappdata(gcbf, 'metricdata');
set(handles.figure1,'HandleVisibility','off');
if(din.figNumber) set(din.figNumber,'HandleVisibility','off'); end
cd([din.dir,'\IPMSM']);
try ipmsm_f(din.fname), catch, errordlg('Input fille error'), end
cd(din.dir);
set(handles.figure1,'HandleVisibility','on');
if(din.figNumber) set(din.figNumber,'HandleVisibility','on'); end
OutputFileDispl(handles,din);
set(handles.text5,'String','Ready');
set(handles.frame2,'BackgroundColor',[0.5 1 0.5]);


% --- Executes on button press outfname pushbutton2.
function pushbutton2_Callback(hObject, eventdata, handles)
help_str1=[...
  'The optimal design computer code is based on input output file method.'
  '                                                                      '
  '1. The input file could be chose using the edit text box              '
  '2. The input file could be open in MATLAB editor using:               '
  '                                       Open Input File button         '
  '3. The user can change the input variable and then save the input     '
  '   file using the same name or a new name. If a new file name is      '
  '   used it is necessary to fill its name in the input edit box.       '
  '4. Press the calculate pushbutton in order to start optimal design    '
  '   The computation could take few seconds up to several minutes       '
  '   depends on variable range and computer performance.                '
  '5. Press the Open Output File pushbutton in order to open the output  '
  '    file results.                                                     '];
helpdlg(help_str1,'Optimal design help');


% --- Executes on button press in pushbutton4.
function pushbutton4_Callback(hObject, eventdata, handles)
din = getappdata(gcbf, 'metricdata');
fname=[din.dir,'\IPMSM\',din.fname,'.m'];
try
    open(fname)
catch
   errordlg('Can not open input file!');
end

% --- Executes on button press in pushbutton5.
function pushbutton5_Callback(hObject, eventdata, handles)
din = getappdata(gcbf, 'metricdata');
fname=[din.dir,'\IPMSM\',get(handles.outFname, 'String');]
try
    open(fname)
catch
   errordlg('Can not open output file!');
end

function pushbutton7_Callback(hObject, eventdata, handles)
set(handles.figure1,'CloseRequestFcn','closereq');
close all;

%--------------------------------------------------------------------

function initialize_gui(fig_handle, handles,figNumber)
din.fname='m5kW';
din.dir=cd;
din.figNumber=figNumber;
setappdata(fig_handle, 'metricdata', din);
set(handles.inFname, 'String', din.fname);
OutputFileDispl(handles,din);

function OutputFileDispl(handles,din)
cd([din.dir,'\IPMSM\']);
set(handles.figure1,'HandleVisibility','off');
output_file=' ';
try eval(din.fname),  catch, errordlg('Input fille error'), end
set(handles.figure1,'HandleVisibility','on');
cd(din.dir);
set(handles.outFname, 'String', output_file);

function my_background(hObject)
if ispc
    set(hObject,'BackgroundColor','white');
else
    set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
end
