function varargout = Ex1i_mc(varargin)
% EX1I_MC M-file for Ex1i_mc.fig
%      EX1I_MC, by itself, creates a new EX1I_MC or raises the existing
%      singleton*.
%
%      H = EX1I_MC returns the handle to a new EX1I_MC or the handle to
%      the existing singleton*.
%
%      EX1I_MC('CALLBACK',hObject,eventData,handles,...) calls the local
%      function named CALLBACK in EX1I_MC.M with the given input arguments.
%
%      EX1I_MC('Property','Value',...) creates a new EX1I_MC or raises the
%      existing singleton*.  Starting from the left, property value pairs are
%      applied to the GUI before Ex1i_mc_OpeningFunction gets called.  An
%      unrecognized property name or invalid value makes property application
%      stop.  All inputs are passed to Ex1i_mc_OpeningFcn via varargin.
%
%      *See GUI Options on GUIDE's Tools menu.  Choose "GUI allows only one
%      instance to run (singleton)".
%
% See also: GUIDE, GUIDATA, GUIHANDLES

% Edit the above text to modify the response to help Ex1i_mc

% Last Modified by GUIDE v2.5 06-Oct-2008 17:42:43

% Begin initialization code - DO NOT EDIT
gui_Singleton = 1;
gui_State = struct('gui_Name',       mfilename, ...
                   'gui_Singleton',  gui_Singleton, ...
                   'gui_OpeningFcn', @Ex1i_mc_OpeningFcn, ...
                   'gui_OutputFcn',  @Ex1i_mc_OutputFcn, ...
                   'gui_LayoutFcn',  [] , ...
                   'gui_Callback',   []);
if nargin && isstr(varargin{1})
    gui_State.gui_Callback = str2func(varargin{1});
end

if nargout
    [varargout{1:nargout}] = gui_mainfcn(gui_State, varargin{:});
else
    gui_mainfcn(gui_State, varargin{:});
end
% End initialization code - DO NOT EDIT

% --- Executes just before Ex1i_mc is made visible.
function Ex1i_mc_OpeningFcn(hObject, eventdata, handles, varargin)
% This function has no output args, see OutputFcn.
% hObject    handle to figure
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
% varargin   command line arguments to Ex1i_mc (see VARARGIN)

% Choose default command line output for Ex1i_mc
handles.output = hObject;
% Update handles structure
guidata(hObject, handles);

if strcmp(get(hObject,'Visible'),'off')
    initialize_gui(hObject, handles);
end

% UIWAIT makes Ex1i_mc wait for user response (see UIRESUME)
% uiwait(handles.figure1);

set(handles.figure1,'Name','Magnetic circuit');


% --- Outputs from this function are returned to the command line.
function varargout = Ex1i_mc_OutputFcn(hObject, eventdata, handles)
% varargout  cell array for returning output args (see VARARGOUT);
% hObject    handle to figure
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Get default command line output from handles structure
varargout{1} = handles.output;

% --- Executes during object creation, after setting all properties.
function a1_CreateFcn(hObject, eventdata, handles)
my_background(hObject);
function a1_Callback(hObject, eventdata, handles)
n_par=1; data_in;

function a2_CreateFcn(hObject, eventdata, handles)
my_background(hObject);
function a2_Callback(hObject, eventdata, handles)
n_par=2; data_in;

function a3_CreateFcn(hObject, eventdata, handles)
my_background(hObject);
function a3_Callback(hObject, eventdata, handles)
n_par=3; data_in;

function l1_CreateFcn(hObject, eventdata, handles)
my_background(hObject);
function l1_Callback(hObject, eventdata, handles)
n_par=4; data_in;

function l2_CreateFcn(hObject, eventdata, handles)
my_background(hObject);
function l2_Callback(hObject, eventdata, handles)
n_par=5; data_in;

function w1_CreateFcn(hObject, eventdata, handles)
my_background(hObject);
function w1_Callback(hObject, eventdata, handles)
n_par=6; data_in;

function agap_CreateFcn(hObject, eventdata, handles)
 my_background(hObject);
function agap_Callback(hObject, eventdata, handles)
n_par=7; data_in;

function N1_CreateFcn(hObject, eventdata, handles)
 my_background(hObject);
function N1_Callback(hObject, eventdata, handles)
n_par=8; data_in;


function pushbutton1_Callback(hObject, eventdata, handles)
din = getappdata(gcbf, 'metricdata');
Ex1_mc(din);

function pushbutton2_Callback(hObject, eventdata, handles)
initialize_gui(gcbf, handles);

function initialize_gui(fig_handle, handles)
din= [15, 12, 10, 25, 40, 12, 0.5, 500];
setappdata(fig_handle, 'metricdata', din);
set(handles.a1, 'String', din(1));
set(handles.a2, 'String', din(2));
set(handles.a3, 'String', din(3));
set(handles.l1, 'String', din(4));
set(handles.l2, 'String', din(5));
set(handles.w1, 'String', din(6));
set(handles.agap, 'String', din(7));
set(handles.N1, 'String', din(8));

axes(handles.axes1);
aim=imread('Cmi.jpg');
image(aim);
set(handles.axes1,'Visible','off');

% --- Executes on button press in pushbutton4.
function pushbutton4_Callback(hObject, eventdata, handles)
close all;

% --- Executes during object creation, after setting all properties.
function axes1_CreateFcn(hObject, eventdata, handles)
%my_background(hObject);

% --- Executes during object creation, after setting all properties.
function edit13_CreateFcn(hObject, eventdata, handles)
my_background(hObject);


% --- Executes during object creation, after setting all properties.
function edit15_CreateFcn(hObject, eventdata, handles)
my_background(hObject);


% --- Executes during object creation, after setting all properties.
function edit16_CreateFcn(hObject, eventdata, handles)
my_background(hObject);

% --- Executes during object creation, after setting all properties.
function edit17_CreateFcn(hObject, eventdata, handles)
my_background(hObject);

% --- Executes during object creation, after setting all properties.
function edit18_CreateFcn(hObject, eventdata, handles)
my_background(hObject);

function edit18_Callback(hObject, eventdata, handles)
my_background(hObject);


% --- Executes during object creation, after setting all properties.
function edit19_CreateFcn(hObject, eventdata, handles)
my_background(hObject);


% --- Executes during object creation, after setting all properties.
function edit20_CreateFcn(hObject, eventdata, handles)
my_background(hObject);


function my_background(hObject)
if ispc
    set(hObject,'BackgroundColor','white');
else
    set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
end

function Ex1_mc(data)
a1=data(1);
a2=data(2);
a3=data(3);
l1=data(4);
l2=data(5);
w1=data(6);
gap=data(7);
N1=data(8);

cmag=load('mate3.bh');
miu_0=4*pi*10^(-7);
mm2m=0.001;

Bref=cmag(:,1);
Href=cmag(:,2);

B1=Bref(1):Bref(end)/200:Bref(end); 
miu_1=miu(Bref,Href,B1);
miu_2=miu(Bref,Href,B1*a1/a2);
miu_3=miu(Bref,Href,B1*a1/a3);

Rm1=(l2-gap+a2)./(miu_1*a1*w1*mm2m);
Rm2=(2*l1+a1+a3)./(miu_2*a2*w1*mm2m);
Rm3=(l2+a2)./(miu_3*a3*w1*mm2m);
Rmag=gap/(miu_0*a1*w1*mm2m);
Rm=Rm3+Rm2+Rm1+Rmag;
FI=B1*a1*w1*mm2m^2;
I1=FI.*Rm/N1;
L1=N1^2./Rm;

figure
plot(Href,Bref);
grid;
xlabel('Magnetic field (A/m)');
ylabel('Flux density (T)');
title('Core magnetisation curve');

figure
plot(I1,FI);
grid;
xlabel('Current (A)');
ylabel('Polar flux (Wb)');

figure
plot(I1,L1);
grid;
xlabel('Current (A)');
ylabel('Inductance (H)');
title('Circuit inductance');

function miu_x=miu(Bref,Href,Bx)
ii=find(Bx==0);
if ~isempty(ii) 
    Bx(ii)=Bref(2)/1000;
end
miu_x=Bx./interp1(Bref,Href,Bx);
ii=find(Bx>Bref(end));
if ~isempty(ii)
    miu_0=4*pi*10^(-7);
    miu1=Bref(end-1)/(miu_0*Href(end-1));
    miu2=Bref(end)/(miu_0*Href(end));
    b1=((miu2-1)*Bref(end)-(miu1-1)*Bref(end-1))/(miu2-miu1);
    a1=(Bref(end-1)-b1)*miu1-Bref(end-1);
    miu_x(ii)=miu_0*(Bx(ii)+a1)./(Bx(ii)-b1); 
end