%Electric transformer example function
function dout=Ex2_trFunc(din);

Sni=din(1); % kVA - rated aparent power
V1n=din(2); %V 
V2n=din(3); %V
fn=din(4); %Hz
m1=din(5);  %phase number
if din(6)==0 con1='Y'; else  con1='D'; end
if din(7)==0 con2='y'; else  con2='d'; end
p0=din(8); % percent of Sn
psc=din(9); % percent of Sn
I10pu=din(10); % percent of I1n
vsc=din(11); % percent of rated voltage
R1perR2=din(12);
X1perX2=din(13);
fi2_deg=din(14);
klmax=din(15);

fi2=fi2_deg*pi/180;
Sn=1000*Sni; %rated power in VA
V1fn=V1n; V2fn=V2n;
if(m1==3)
    if(con1=='Y') V1fn=V1n/sqrt(3); end
    if(con2=='y') V2fn=V2n/sqrt(3); end
end
Pcun=psc*Sn/100;
Pfen=p0*Sn/100;
I1fn=(Sn+Pcun+Pfen)/(m1*V1fn); I1n=I1fn;
I2fn=Sn/(m1*V2fn); I2n=I2fn;
if(m1==3)
    if(con1=='D') I1n=I1fn*sqrt(3); end
    if(con2=='d') I2n=I2fn*sqrt(3); end
end
Zsc=vsc*V1fn/(100*I1fn);
Rsc=Pcun/(m1*I1fn^2);
Xsc=sqrt(Zsc^2-Rsc^2);
fisc=acos(Rsc/Zsc);
V2p=sqrt(V1fn^2-(Xsc*I1fn)^2)-Rsc*I1fn;
ktr=V2p/V2fn;
I10=I10pu*I1fn/100;
Z0=V1fn/I10;
R10=Pfen/(m1*I10^2);
X10=sqrt(Z0^2-R10^2);
R1=Rsc*R1perR2/(1+R1perR2);
R2p=Rsc-R1;
X1=Xsc*X1perX2/(1+X1perX2);
X2p=Xsc-X1;
Rm=R10-R1; Xm=X10-X1;

I2fnp=I2fn/ktr;
Znp=V2p/I2fnp;

Rnp=Znp*cos(fi2);
Xnp=Znp*sin(fi2);
kl=0:0.01:klmax; kl(1)=1e-4; klinv=1./kl;
Ze=R1+j*X1+(Rm+j*Xm)*(R2p+Rnp*klinv+j*(X2p+Xnp*klinv))./(Rm+R2p+Rnp*klinv+j*(Xm+X2p+Xnp*klinv));
I1f=V1fn./Ze;
V0=V1fn-(R1+j*X1)*I1f;
I2fp=V0./(R2p+Rnp*klinv+j*(X2p+Xnp*klinv));
V2fp=V0-I2fp*(R2p+j*X2p);
kl2=abs(I2fp)*ktr/I2fn;
V2fpa=V1fn*(1-kl*0.01*vsc*cos(fi2-fisc));
V2f=V2fp/ktr; V2fa=V2fpa/ktr;
Pcu=m1*real((R1*I1f.*conj(I1f)+R2p*I2fp.*conj(I2fp)));
I1m=I1f-I2fp;
Pfe=m1*Rm*real(I1m.*conj(I1m));
Pout=m1*real(V2fp.*conj(I2fp));
eta=Pout./(Pout+Pcu+Pfe);
pf1=cos(angle(I1f));
pf2=Pout./(m1*abs(V2fp).*abs(I2fp));
kleffm=sqrt(Pfen/Pcun);
etan=Sn/(Sn+Pcun+Pfen);
etamax=kleffm*Sn/(kleffm*Sn+kleffm^2*Pcun+Pfen);
cpf=0:0.01:1;
etam=kleffm*Sn*cpf./(kleffm*Sn*cpf+kleffm^2*Pcun+Pfen);

if(m1==3)
    if(con1=='Y') V2=V2f*sqrt(3); end
    if(con2=='y') V2a=V2fa*sqrt(3); end
end

dout=[I1n I2n Pcun Pfen R1 R2p X1 X2p Rm Xm ktr etan etamax kleffm];

figure
plot(kl,V2fa,kl2,abs(V2f))
grid
xlabel('Load factor')
ylabel('Output voltage (V)')
legend('Linear aprox.', 'Exact value')

figure
plot(kl2,eta,kl2,pf1,kl2,pf2)
grid
xlabel('Load factor')
legend('efficiency', 'Input power factor','Output power factor')

figure
plot(cpf,etam)
grid
xlabel('Power factor');
title('Maximum efficiency versus power factor');
%legend('efficiency', 'Input power factor','Output power factor')