function varargout = Ex3i_trNS(varargin)
% EX3I_TRNS M-file for Ex3i_trNS.fig
%      EX3I_TRNS, by itself, creates a new EX3I_TRNS or raises the existing
%      singleton*.
%
%      H = EX3I_TRNS returns the handle to a new EX3I_TRNS or the handle to
%      the existing singleton*.
%
%      EX3I_TRNS('CALLBACK',hObject,eventData,handles,...) calls the local
%      function named CALLBACK in EX3I_TRNS.M with the given input arguments.
%
%      EX3I_TRNS('Property','Value',...) creates a new EX3I_TRNS or raises the
%      existing singleton*.  Starting from the left, property value pairs are
%      applied to the GUI before Ex3i_trNS_OpeningFunction gets called.  An
%      unrecognized property name or invalid value makes property application
%      stop.  All inputs are passed to Ex3i_trNS_OpeningFcn via varargin.
%
%      *See GUI Options on GUIDE's Tools menu.  Choose "GUI allows only one
%      instance to run (singleton)".
%
% See also: GUIDE, GUIDATA, GUIHANDLES

% Edit the above text to modify the response to help Ex3i_trNS

% Last Modified by GUIDE v2.5 05-Oct-2008 23:59:38

% Begin initialization code - DO NOT EDIT
gui_Singleton = 1;
gui_State = struct('gui_Name',       mfilename, ...
                   'gui_Singleton',  gui_Singleton, ...
                   'gui_OpeningFcn', @Ex3i_trNS_OpeningFcn, ...
                   'gui_OutputFcn',  @Ex3i_trNS_OutputFcn, ...
                   'gui_LayoutFcn',  [] , ...
                   'gui_Callback',   []);
if nargin & isstr(varargin{1})
    gui_State.gui_Callback = str2func(varargin{1});
end

if nargout
    [varargout{1:nargout}] = gui_mainfcn(gui_State, varargin{:});
else
    gui_mainfcn(gui_State, varargin{:});
end
% End initialization code - DO NOT EDIT

% --- Executes just before Ex3i_trNS is made visible.
function Ex3i_trNS_OpeningFcn(hObject, eventdata, handles, varargin)
% This function has no output args, see OutputFcn.
% hObject    handle to figure
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
% varargin   command line arguments to Ex3i_trNS (see VARARGIN)

% Choose default command line output for Ex3i_trNS
handles.output = hObject;

% Update handles structure
guidata(hObject, handles);

if strcmp(get(hObject,'Visible'),'off')
    initialize_gui(hObject, handles);
end
set(handles.figure1,'Name','Non symetric current load');

% UIWAIT makes Ex3i_trNS wait for user response (see UIRESUME)
% uiwait(handles.figure1);


% --- Outputs from this function are returned to the command line.
function varargout = Ex3i_trNS_OutputFcn(hObject, eventdata, handles)
varargout{1} = handles.output;

%-----------------------------------------------------------------------
%           ---  Input Parameters   ---
%-----------------------------------------------------------------------

function V1n_CreateFcn(hObject, eventdata, handles)
my_background(hObject);
function V1n_Callback(hObject, eventdata, handles)
n_par=1; data_in;

function V2n_CreateFcn(hObject, eventdata, handles)
my_background(hObject);
function V2n_Callback(hObject, eventdata, handles)
n_par=2; data_in;

function X0_CreateFcn(hObject, eventdata, handles)
my_background(hObject);
function X0_Callback(hObject, eventdata, handles)
n_par=3; data_in;

function I2a_CreateFcn(hObject, eventdata, handles)
my_background(hObject);
function I2a_Callback(hObject, eventdata, handles)
n_par=4; data_in;

function I2b_CreateFcn(hObject, eventdata, handles)
my_background(hObject);
function I2b_Callback(hObject, eventdata, handles)
n_par=5; data_in;

function I2c_CreateFcn(hObject, eventdata, handles)
my_background(hObject);
function I2c_Callback(hObject, eventdata, handles)
n_par=6; data_in;

%------------------------------------------------------------
%           ---  Output results   ---
%------------------------------------------------------------

function I1a_CreateFcn(hObject, eventdata, handles)
my_background(hObject);

function I1b_CreateFcn(hObject, eventdata, handles)
my_background(hObject);

function I1c_CreateFcn(hObject, eventdata, handles)
my_background(hObject);

function V2a_CreateFcn(hObject, eventdata, handles)
my_background(hObject);

function V2b_CreateFcn(hObject, eventdata, handles)
my_background(hObject);

function V2c_CreateFcn(hObject, eventdata, handles)
my_background(hObject);

%------------------------------------------------------------
%           ---  Push button actions   ---
%------------------------------------------------------------

% --- Executes on button press in pushbutton1.
function pushbutton1_Callback(hObject, eventdata, handles)
din = getappdata(gcbf, 'metricdata');
dout = Ex3_trNS(din);
set(handles.I1a, 'String', dout(1));
set(handles.I1b, 'String', dout(2));
set(handles.I1c, 'String', dout(3));
set(handles.V2a, 'String', dout(4));
set(handles.V2b, 'String', dout(5));
set(handles.V2c, 'String', dout(6));

% --- Executes on button press in pushbutton2.
function pushbutton2_Callback(hObject, eventdata, handles)
initialize_gui(gcbf, handles);

function pushbutton7_Callback(hObject, eventdata, handles)
close('Non symetric current load');

function initialize_gui(fig_handle, handles)
din=[6000 380 1 120 0 0];
setappdata(fig_handle, 'metricdata', din);
set(handles.V1n, 'String', din(1));
set(handles.V2n, 'String', din(2));
set(handles.X0, 'String', din(3)); 
set(handles.I2a, 'String', din(4));
set(handles.I2b, 'String', din(5));
set(handles.I2c, 'String', din(6));

function my_background(hObject)
if ispc
    set(hObject,'BackgroundColor','white');
else
    set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
end

function dout = Ex3_trNS(din)
V1n=din(1); V2n=din(2); X0=din(3); 
Ia=din(4); Ib=din(5); Ic=din(6);
V2fn=V2n/sqrt(3);

a=exp(-j*(2*pi/3));
A1=[1 a a*a; 1 a*a a; 1 1 1]/3;
A2=[1 1 1; a*a a 1; a a*a 1];
I2di0=A1*[Ia; Ib; Ic];
I1di0=-V2n/V1n*I2di0; I1di0(3)=0;
I1=A2*I1di0;

Uea0=-j*X0*I2di0(3);
Uead=sqrt(V2fn^2-(imag(Uea0))^2)-j*imag(Uea0);
U2di0=[Uead 0 Uea0]';
U2abc=A2*U2di0;

dout=abs([I1 U2abc]);