function varargout = Ex4i_trNS(varargin)
% EX4I_TRNS M-file for Ex4i_trNS.fig
%      EX4I_TRNS, by itself, creates a new EX4I_TRNS or raises the existing
%      singleton*.
%
%      H = EX4I_TRNS returns the handle to a new EX4I_TRNS or the handle to
%      the existing singleton*.
%
%      EX4I_TRNS('CALLBACK',hObject,eventData,handles,...) calls the local
%      function named CALLBACK in EX4I_TRNS.M with the given input arguments.
%
%      EX4I_TRNS('Property','Value',...) creates a new EX4I_TRNS or raises the
%      existing singleton*.  Starting from the left, property value pairs are
%      applied to the GUI before Ex4i_trNS_OpeningFunction gets called.  An
%      unrecognized property name or invalid value makes property application
%      stop.  All inputs are passed to Ex4i_trNS_OpeningFcn via varargin.
%
%      *See GUI Options on GUIDE's Tools menu.  Choose "GUI allows only one
%      instance to run (singleton)".
%
% See also: GUIDE, GUIDATA, GUIHANDLES

% Edit the above text to modify the response to help Ex4i_trNS

% Last Modified by GUIDE v2.5 06-Oct-2008 09:19:20

% Begin initialization code - DO NOT EDIT
gui_Singleton = 1;
gui_State = struct('gui_Name',       mfilename, ...
                   'gui_Singleton',  gui_Singleton, ...
                   'gui_OpeningFcn', @Ex4i_trNS_OpeningFcn, ...
                   'gui_OutputFcn',  @Ex4i_trNS_OutputFcn, ...
                   'gui_LayoutFcn',  [] , ...
                   'gui_Callback',   []);
if nargin & isstr(varargin{1})
    gui_State.gui_Callback = str2func(varargin{1});
end

if nargout
    [varargout{1:nargout}] = gui_mainfcn(gui_State, varargin{:});
else
    gui_mainfcn(gui_State, varargin{:});
end
% End initialization code - DO NOT EDIT

% --- Executes just before Ex4i_trNS is made visible.
function Ex4i_trNS_OpeningFcn(hObject, eventdata, handles, varargin)
% This function has no output args, see OutputFcn.
% hObject    handle to figure
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
% varargin   command line arguments to Ex4i_trNS (see VARARGIN)

% Choose default command line output for Ex4i_trNS
handles.output = hObject;

% Update handles structure
guidata(hObject, handles);

if strcmp(get(hObject,'Visible'),'off')
    initialize_gui(hObject, handles);
end
set(handles.figure1,'Name','Non symetric load');

% UIWAIT makes Ex4i_trNS wait for user response (see UIRESUME)
% uiwait(handles.figure1);


% --- Outputs from this function are returned to the command line.
function varargout = Ex4i_trNS_OutputFcn(hObject, eventdata, handles)
varargout{1} = handles.output;

%-----------------------------------------------------------------------
%           ---  Input Parameters   ---
%-----------------------------------------------------------------------

function V20_CreateFcn(hObject, eventdata, handles)
my_background(hObject);
function V20_Callback(hObject, eventdata, handles)
n_par=1; data_in;

function Zsc_CreateFcn(hObject, eventdata, handles)
my_background(hObject);
function Zsc_Callback(hObject, eventdata, handles)
n_par=2; data_in;

function X0_CreateFcn(hObject, eventdata, handles)
my_background(hObject);
function X0_Callback(hObject, eventdata, handles)
n_par=3; data_in;

function Za_CreateFcn(hObject, eventdata, handles)
my_background(hObject);
function Za_Callback(hObject, eventdata, handles)
n_par=4; data_in;

function Zb_CreateFcn(hObject, eventdata, handles)
my_background(hObject);
function Zb_Callback(hObject, eventdata, handles)
n_par=5; data_in;

function Zc_CreateFcn(hObject, eventdata, handles)
my_background(hObject);
function Zc_Callback(hObject, eventdata, handles)
n_par=6; data_in;

%------------------------------------------------------------
%           ---  Output results   ---
%------------------------------------------------------------

function I2a_CreateFcn(hObject, eventdata, handles)
my_background(hObject);

function I2b_CreateFcn(hObject, eventdata, handles)
my_background(hObject);

function I2c_CreateFcn(hObject, eventdata, handles)
my_background(hObject);

function V2a_CreateFcn(hObject, eventdata, handles)
my_background(hObject);

function V2b_CreateFcn(hObject, eventdata, handles)
my_background(hObject);

function V2c_CreateFcn(hObject, eventdata, handles)
my_background(hObject);

%------------------------------------------------------------
%           ---  Push button actions   ---
%------------------------------------------------------------

% --- Executes on button press in pushbutton1.
function pushbutton1_Callback(hObject, eventdata, handles)
din = getappdata(gcbf, 'metricdata');
dout = Ex4_trNS(din);
set(handles.I2a, 'String', dout(1));
set(handles.I2b, 'String', dout(2));
set(handles.I2c, 'String', dout(3));
set(handles.V2a, 'String', dout(4));
set(handles.V2b, 'String', dout(5));
set(handles.V2c, 'String', dout(6));

% --- Executes on button press in pushbutton2.
function pushbutton2_Callback(hObject, eventdata, handles)
initialize_gui(gcbf, handles);

function pushbutton7_Callback(hObject, eventdata, handles)
close('Non symetric load');

function initialize_gui(fig_handle, handles)
din=[240 0.1+0.3j 4j 1 1-j 1+j];
setappdata(fig_handle, 'metricdata', din);
set(handles.V20, 'String', din(1));
set(handles.Zsc, 'String', num2str(din(2)));
set(handles.X0, 'String', num2str(din(3))); 
set(handles.Za, 'String', num2str(din(4)));
set(handles.Zb, 'String', num2str(din(5)));
set(handles.Zc, 'String', num2str(din(6)));

function my_background(hObject)
if ispc
    set(hObject,'BackgroundColor','white');
else
    set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
end

function dout = Ex4_trNS(din)
V20=din(1); Zsc=din(2); Z0=din(3); 
Za=din(4); Zb=din(5); Zc=din(6);

Ys=[1/Za 0 0; 0 1/Zb 0; 0 0 1/Zc];

a=exp(j*2*pi/3);
A1=[1 a a*a; 1 a*a a; 1 1 1]/3;
A2=[1 1 1; a*a a 1; a a*a 1];
I=[1 0 0;0 1 0; 0 0 1];
Ztrdio=[Zsc 0 0; 0 Zsc 0; 0 0 Z0];
A3=I+A2*Ztrdio*A1*Ys;

U2edio=[V20; 0; 0];
U2=inv(A3)*A2*U2edio;
I2=Ys*U2;

dout=abs([I2 U2]);