function varargout = Ex6i_dcMs(varargin)
% EX6I_DCMS M-file for Ex6i_dcMs.fig
%      EX6I_DCMS, by itself, creates a new EX6I_DCMS or raises the existing
%      singleton*.
%
%      H = EX6I_DCMS returns the handle to a new EX6I_DCMS or the handle to
%      the existing singleton*.
%
%      EX6I_DCMS('CALLBACK',hObject,eventData,handles,...) calls the local
%      function named CALLBACK in EX6I_DCMS.M with the given input arguments.
%
%      EX6I_DCMS('Property','Value',...) creates a new EX6I_DCMS or raises the
%      existing singleton*.  Starting from the left, property value pairs are
%      applied to the GUI before Ex6i_dcMs_OpeningFunction gets called.  An
%      unrecognized property name or invalid value makes property application
%      stop.  All inputs are passed to Ex6i_dcMs_OpeningFcn via varargin.
%
%      *See GUI Options on GUIDE's Tools menu.  Choose "GUI allows only one
%      instance to run (singleton)".
%
% See also: GUIDE, GUIDATA, GUIHANDLES

% Edit the above text to modify the response to help Ex6i_dcMs

% Last Modified by GUIDE v2.5 07-Oct-2008 14:13:56

% Begin initialization code - DO NOT EDIT
gui_Singleton = 1;
gui_State = struct('gui_Name',       mfilename, ...
                   'gui_Singleton',  gui_Singleton, ...
                   'gui_OpeningFcn', @Ex6i_dcMs_OpeningFcn, ...
                   'gui_OutputFcn',  @Ex6i_dcMs_OutputFcn, ...
                   'gui_LayoutFcn',  [] , ...
                   'gui_Callback',   []);
if nargin && ischar(varargin{1})
    gui_State.gui_Callback = str2func(varargin{1});
end

if nargout
    [varargout{1:nargout}] = gui_mainfcn(gui_State, varargin{:});
else
    gui_mainfcn(gui_State, varargin{:});
end
% End initialization code - DO NOT EDIT

% --- Executes just before Ex6i_dcMs is made visible.
function Ex6i_dcMs_OpeningFcn(hObject, eventdata, handles, varargin)
% This function has no output args, see OutputFcn.
% hObject    handle to figure
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
% varargin   command line arguments to Ex6i_dcMs (see VARARGIN)

% Choose default command line output for Ex6i_dcMs
handles.output = hObject;

% Update handles structure
guidata(hObject, handles);

if strcmp(get(hObject,'Visible'),'off')
    initialize_gui(hObject, handles);
end
set(handles.figure1,'Name','DC Motor');

% UIWAIT makes Ex6i_dcMs wait for user response (see UIRESUME)
% uiwait(handles.figure1);


% --- Outputs from this function are returned to the command line.
function varargout = Ex6i_dcMs_OutputFcn(hObject, eventdata, handles)
varargout{1} = handles.output;

%-----------------------------------------------------------------------
%           ---  Input Parameters   ---
%-----------------------------------------------------------------------

function Pn_CreateFcn(hObject, eventdata, handles)
my_background(hObject);
function Pn_Callback(hObject, eventdata, handles)
n_par=1; data_in;

function Vn_CreateFcn(hObject, eventdata, handles)
my_background(hObject);
function Vn_Callback(hObject, eventdata, handles)
n_par=2; data_in;

function nn_CreateFcn(hObject, eventdata, handles)
my_background(hObject);
function nn_Callback(hObject, eventdata, handles)
n_par=3; data_in;

function etan_CreateFcn(hObject, eventdata, handles)
my_background(hObject);
function etan_Callback(hObject, eventdata, handles)
n_par=4; data_in;

function Pex_CreateFcn(hObject, eventdata, handles)
my_background(hObject);
function Pex_Callback(hObject, eventdata, handles)
n_par=5; data_in;

function Pmec_CreateFcn(hObject, eventdata, handles)
my_background(hObject);
function Pmec_Callback(hObject, eventdata, handles)
n_par=6; data_in;

function Pfe_CreateFcn(hObject, eventdata, handles)
my_background(hObject);
function Pfe_Callback(hObject, eventdata, handles)
n_par=7; data_in;



%------------------------------------------------------------
%           ---  Output results   ---
%------------------------------------------------------------

function In_CreateFcn(hObject, eventdata, handles)
my_background(hObject);

function Rs_CreateFcn(hObject, eventdata, handles)
my_background(hObject);

function Ra_CreateFcn(hObject, eventdata, handles)
my_background(hObject);

function Tn_CreateFcn(hObject, eventdata, handles)
my_background(hObject);

function Tmin_CreateFcn(hObject, eventdata, handles)
my_background(hObject);

function T0_CreateFcn(hObject, eventdata, handles)
my_background(hObject);


%------------------------------------------------------------
%           ---  Push button actions   ---
%------------------------------------------------------------

% --- Executes on button press in pushbutton1.
function pushbutton1_Callback(hObject, eventdata, handles)
din = getappdata(gcbf, 'metricdata');
dout = Ex6_dcMs(din);
set(handles.In, 'String', dout(1));
set(handles.Ra, 'String', dout(2));
set(handles.Rs, 'String', dout(3));
set(handles.Tn, 'String', dout(4));
set(handles.T0, 'String', dout(5));
set(handles.Tmin, 'String', dout(6));


% --- Executes on button press in pushbutton2.
function pushbutton2_Callback(hObject, eventdata, handles)
initialize_gui(gcbf, handles);

function pushbutton7_Callback(hObject, eventdata, handles)
close('DC Motor');
close all;

function initialize_gui(fig_handle, handles)
din=[2.2 110 1500 85 3 2 1.5];
setappdata(fig_handle, 'metricdata', din);
set(handles.Pn, 'String', din(1));
set(handles.Vn, 'String', din(2));
set(handles.nn, 'String', din(3)); 
set(handles.etan, 'String', din(4));
set(handles.Pex, 'String', din(5));
set(handles.Pmec, 'String', din(6));
set(handles.Pfe, 'String', din(7));


function my_background(hObject)
if ispc
    set(hObject,'BackgroundColor','white');
else
    set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
end

function dout = Ex6_dcMs(din)
Pn=din(1)*1000; Vn=din(2); nn=din(3);
etan=din(4); Pexp=din(5); Pmecp=din(6); Pfep=din(7);
nmaxpu=2;
nmax=nmaxpu*nn;
cmag2;

wn=pi*nn/30; wmax=pi*nmax/30;
In=Pn/(Vn*etan/100);
Pexn=Pn*Pexp/100;
Pmecn=Pn*Pmecp/100;
Pfen=Pn*Pfep/100;
Plossn=Pn*(100/etan-1);
Pcun=Plossn-Pexn-Pmecn-Pfen;
Ra=Pcun/(In^2);
Rs=Pexn/(In^2);
Tn=Pn/wn;
T0=Pmecn/wn;

Psin=(Vn-(Ra+Rs)*In)/wn;
Psiref=fipu*Psin;
Iexref=Iepu*In;
ktfe=Pfen/(wn*Psin)^2;

Ia=[0.1:0.025:2]*In;
[w1_n, T1_n, Ia1_n,Tmin]=dcMseq(Vn,Ia,Ra,Rs,1,Iexref,Psiref,ktfe,T0,nmax);
[w1_r, T1_r, Ia1_r,T1]=dcMseq(Vn,Ia,2*Ra,Rs,1,Iexref,Psiref,ktfe,T0,nmax);
[w2_r, T2_r, Ia2_r,T1]=dcMseq(Vn,Ia,5*Ra,Rs,1,Iexref,Psiref,ktfe,T0,nmax);
[w3_r, T3_r, Ia3_r,T1]=dcMseq(Vn,Ia,10*Ra,Rs,1,Iexref,Psiref,ktfe,T0,nmax);

[w1_v, T1_v, Ia1_v,T1]=dcMseq(0.8*Vn,Ia,Ra,Rs,1,Iexref,Psiref,ktfe,T0,nmax);
[w2_v, T2_v, Ia2_v,T1]=dcMseq(0.5*Vn,Ia,Ra,Rs,1,Iexref,Psiref,ktfe,T0,nmax);
[w3_v, T3_v, Ia3_v,T1]=dcMseq(0.2*Vn,Ia,Ra,Rs,1,Iexref,Psiref,ktfe,T0,nmax);

[w1_e, T1_e, Ia1_e,T1]=dcMseq(Vn,Ia,Ra,Rs,0.8,Iexref,Psiref,ktfe,T0,nmax);
[w2_e, T2_e, Ia2_e,T1]=dcMseq(Vn,Ia,Ra,Rs,0.6,Iexref,Psiref,ktfe,T0,nmax);
[w3_e, T3_e, Ia3_e,T1]=dcMseq(Vn,Ia,Ra,Rs,0.4,Iexref,Psiref,ktfe,T0,nmax);


figure
plot(T1_n,w1_n,Tn,nn,'o',T1_r,w1_r,T2_r,w2_r,T3_r,w3_r);
grid
xlabel('Torque (N*m)');
ylabel('Speed (rpm)');
title('Mechanical characteristic with additional resistance');
legend('natural- Rad=0','rated point', 'Rad = Ra', 'Rad =4 Ra', 'Rad = 9 Ra');

figure
plot(T1_n,w1_n,Tn,nn,'o',T1_v,w1_v,T2_v,w2_v,T3_v,w3_v);
grid
xlabel('Torque (N*m)');
ylabel('Speed (rpm)');
title('Mechanical characteristic using variable voltage');
legend('    Vn', 'rated point','0.8 Vn','0.5 Vn','0.2 Vn');

figure
plot(T1_n,w1_n,Tn,nn,'o',T1_e,w1_e,T2_e,w2_e,T3_e,w3_e);
grid
xlabel('Torque (N*m)');
ylabel('Speed (rpm)');
title('Mechanical characteristic using variable voltage');
legend('    Ifn', 'rated point','0.8 Ifn','0.6 Ifnn','0.4 Ifn');

dout=abs([In Ra Rs Tn T0 Tmin]);


function [ns, Ts, Iaout, Tmin]=dcMseq(Va,Ia,Ra,Rs,kex,Iexref,Psiref,kfe,T0,nmax)
Iex=kex*Ia;
ii=find(Iex<=Iexref(end));
Psi(ii)=interp1(Iexref,Psiref,Iex(ii));
ii=find(Iex>Iexref(end));
if ~isempty(ii);
    p1=Psiref(end-1); p2=Psiref(end);
    i1=Iexref(end-1); i2=Iexref(end);
    i0=(p2-p1)*i1*i2/(p1*i2-p2*i1);
    Psisat=p1*p2*(i2-i1)/(p1*i2-p2*i1);
    Psi(ii)=Psisat*Iex(ii)./(Iex(ii)+i0);
end
ws=(Va-(Ra+kex*Rs)*Ia)./Psi;
Tem=Ia.*Psi;
Ts=Tem-T0-kfe*ws.*Psi.^2;
n1=ws/pi*30;
if(nmax>max(n1)) Tmin=0; else Tmin=interp1(n1,Ts,nmax);end
ii=find((n1<nmax)&(n1>-nmax));
ns=n1(ii);
Ts=Ts(ii);
Iaout=Ia(ii);
