function varargout = Ex7i_IM(varargin)
% EX7I_IM M-file for Ex7i_IM.fig
%      EX7I_IM, by itself, creates a new EX7I_IM or raises the existing
%      singleton*.
%
%      H = EX7I_IM returns the handle to a new EX7I_IM or the handle to
%      the existing singleton*.
%
%      EX7I_IM('CALLBACK',hObject,eventData,handles,...) calls the local
%      function named CALLBACK sk EX7I_IM.M with the given input arguments.
%
%      EX7I_IM('Property','Value',...) creates a new EX7I_IM or raises the
%      existing singleton*.  Starting from the left, property value pairs are
%      applied to the GUI before Ex7i_IM_OpeningFunction gets called.  An
%      unrecognized property name or invalid value makes property application
%      stop.  All inputs are passed to Ex7i_IM_OpeningFcn via varargin.
%
%      *See GUI Options on GUIDE's Tools menu.  Choose "GUI allows only one
%      instance to run (singleton)".
%
% See also: GUIDE, GUIDATA, GUIHANDLES

% Edit the above text to modify the response to help Ex7i_IM

% Last Modified by GUIDE v2.5 09-Oct-2008 23:22:16

% Begin initialization code - DO NOT EDIT
gui_Singleton = 1;
gui_State = struct('gui_Name',       mfilename, ...
                   'gui_Singleton',  gui_Singleton, ...
                   'gui_OpeningFcn', @Ex7i_IM_OpeningFcn, ...
                   'gui_OutputFcn',  @Ex7i_IM_OutputFcn, ...
                   'gui_LayoutFcn',  [] , ...
                   'gui_Callback',   []);
if nargin & isstr(varargin{1})
    gui_State.gui_Callback = str2func(varargin{1});
end

if nargout
    [varargout{1:nargout}] = gui_mainfcn(gui_State, varargin{:});
else
    gui_mainfcn(gui_State, varargin{:});
end
% End initialization code - DO NOT EDIT

% --- Executes just before Ex7i_IM is made visible.
function Ex7i_IM_OpeningFcn(hObject, eventdata, handles, varargin)
% This function has no output args, see OutputFcn.
% hObject    handle to figure
% eventdata  reserved - to be defined sk a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
% varargin   command line arguments to Ex7i_IM (see VARARGIN)

% Choose default command line output for Ex7i_IM
handles.output = hObject;

% Update handles structure
guidata(hObject, handles);

if strcmp(get(hObject,'Visible'),'off')
    initialize_gui(hObject, handles);
end
set(handles.figure1,'Name','Induction Motor');

% UIWAIT makes Ex7i_IM wait for user response (see UIRESUME)
% uiwait(handles.figure1);


% --- Outputs from this function are returned to the command line.
function varargout = Ex7i_IM_OutputFcn(hObject, eventdata, handles)
varargout{1} = handles.output;

%-----------------------------------------------------------------------
%           ---  Input Parameters   ---
%-----------------------------------------------------------------------

function Vn_CreateFcn(hObject, eventdata, handles)
my_background(hObject);
function Vn_Callback(hObject, eventdata, handles)
n_par=1; data_in;

function fn_CreateFcn(hObject, eventdata, handles)
my_background(hObject);
function fn_Callback(hObject, eventdata, handles)
n_par=2; data_in;

function pp_CreateFcn(hObject, eventdata, handles)
my_background(hObject);
function pp_Callback(hObject, eventdata, handles)
n_par=3; data_in;

function R1_CreateFcn(hObject, eventdata, handles)
my_background(hObject);
function R1_Callback(hObject, eventdata, handles)
n_par=4; data_in;

function R2_CreateFcn(hObject, eventdata, handles)
my_background(hObject);
function R2_Callback(hObject, eventdata, handles)
n_par=5; data_in;

function L1sigm_CreateFcn(hObject, eventdata, handles)
my_background(hObject);
function L1sigm_Callback(hObject, eventdata, handles)
n_par=6; data_in;

function L2sigm_CreateFcn(hObject, eventdata, handles)
my_background(hObject);
function L2sigm_Callback(hObject, eventdata, handles)
n_par=7; data_in;

function R1m_CreateFcn(hObject, eventdata, handles)
my_background(hObject);
function R1m_Callback(hObject, eventdata, handles)
n_par=8; data_in;

function L1m_CreateFcn(hObject, eventdata, handles)
function L1m_Callback(hObject, eventdata, handles)
n_par=9; data_in;

%------------------------------------------------------------
%           ---  Output results   ---
%------------------------------------------------------------

function sk_CreateFcn(hObject, eventdata, handles)
my_background(hObject);

function Tk_CreateFcn(hObject, eventdata, handles)
my_background(hObject);

function Pk_CreateFcn(hObject, eventdata, handles)
my_background(hObject);

function Ik_CreateFcn(hObject, eventdata, handles)
my_background(hObject);

function etak_CreateFcn(hObject, eventdata, handles)
my_background(hObject);

function pfk_CreateFcn(hObject, eventdata, handles)
my_background(hObject);

function Ts_CreateFcn(hObject, eventdata, handles)
my_background(hObject);

function Is_CreateFcn(hObject, eventdata, handles)
my_background(hObject);

function pfp_CreateFcn(hObject, eventdata, handles)
my_background(hObject);

function I0_CreateFcn(hObject, eventdata, handles)
my_background(hObject);

function pf0_CreateFcn(hObject, eventdata, handles)
my_background(hObject);

%------------------------------------------------------------
%           ---  Push button actions   ---
%------------------------------------------------------------

% --- Executes on button press sk pushbutton1.
function pushbutton1_Callback(hObject, eventdata, handles)
din = getappdata(gcbf, 'metricdata');
dout = Ex7i_IM1(din);
set(handles.sk, 'String', dout(1));
set(handles.Tk, 'String', dout(2));
set(handles.Pk, 'String', dout(3));
set(handles.Ik, 'String', dout(4));
set(handles.etak, 'String', dout(5));
set(handles.pfk, 'String', dout(6));
set(handles.Ts, 'String', dout(7));
set(handles.Is, 'String', dout(8));
set(handles.pfp, 'String', dout(9));
set(handles.I0, 'String', dout(10));
set(handles.pf0, 'String', dout(11));

% --- Executes on button press sk pushbutton2.
function pushbutton2_Callback(hObject, eventdata, handles)
initialize_gui(gcbf, handles);

function pushbutton7_Callback(hObject, eventdata, handles)
close('Induction Motor');
close all;

function initialize_gui(fig_handle, handles)
din=[220 50 2 0.3 0.25 0.0032 0.0029 1.5 0.0403];
setappdata(fig_handle, 'metricdata', din);
set(handles.Vn, 'String', din(1));
set(handles.fn, 'String', din(2));
set(handles.pp, 'String', din(3)); 
set(handles.R1, 'String', din(4));
set(handles.R2, 'String', din(5));
set(handles.L1sigm, 'String', din(6));
set(handles.L2sigm, 'String', din(7));
set(handles.R1m, 'String', din(8));
set(handles.L1m, 'String', din(9));

function my_background(hObject)
if ispc
    set(hObject,'BackgroundColor','white');
else
    set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
end

function dout = Ex7i_IM1(din)

V1=din(1); f1=din(2); pp=din(3);R1=din(4); R2=din(5);
L1sig=din(6); L2sig=din(7); R1m=din(8); L1m=din(9);
Pmec=0;

s=(-1):0.001:1;
ii=find(s==0); s(ii)=eps;
w1=2*pi*f1;
Z1=R1+1i*w1*L1sig;
Z2e=(R2./s)+1i*w1*L2sig;
Z1m=R1m+1i*w1*L1m;
Ze=Z1+(Z1m*Z2e)./(Z1m+Z2e);

I1=V1./Ze;
I2=V1./(Z1+Z2e+(Z1*Z2e/Z1m));

Mem=3*pp*R2./s.*(abs(I2)).^2/(2*pi*f1);
n=(f1/pp)*(1-s)*60;
I1m=I1-I2;

Pcu1=3*R1.*(abs(I1)).^2;
Pcu2=3*R2.*(abs(I2)).^2;
Pfe=3*R1m.*(abs(I1m)).^2;
eta=zeros(size(s));
Pshaft=Mem.*(n*pi/30)-Pmec;
Pgrid=Pshaft+Pmec+Pcu1+Pcu2+Pfe;
ii=find(Pshaft>0);
eta(ii)=Pshaft(ii)./Pgrid(ii);
ii=find(Pgrid<0);
eta(ii)=Pgrid(ii)./Pshaft(ii);
cosphi=cos(angle(I1));

Tk=max(Mem);
ii=find(Mem==Tk);
sk=s(ii);
Pk=Tk*(1-sk)*2*pi*f1/pp;
Ik=abs(I1(ii));
pfk=cosphi(ii);
etak=eta(ii);
Is=interp1(s,abs(I1),1);
Ts=interp1(s,Mem,1);
pfs=interp1(s,cosphi,1);
I0=interp1(s,abs(I1),0);
pf0=interp1(s,cosphi,0);

dout=[sk,Tk,Pk,Ik,etak,pfk,Ts,Is,pfs,I0,pf0];
figure
plot(s,Mem);
grid;
xlabel('slip');
ylabel('Electromechanical Torque (Nm)');

figure
plot(n,Mem);
grid;
xlabel('Speed (rpm)');
ylabel('Electromagnetic Torque (Nm)');

figure
plot(s,abs(I1));
grid;
xlabel('slip');
ylabel('Current (A)');

figure
plot(s,eta, s,cosphi);
grid;
xlabel('slip)');
legend('Efficiency','cosphi');
title('Efficiency and power factor versus slip');

figure
plot(Mem,abs(I1));
grid;
xlabel('Electromechanical Torque (Nm)');
ylabel('Curentul (A)');


figure
plot(Mem,eta,Mem,cosphi);
grid;
xlabel('Electromagnetic Torque (Nm)');
legend('Efficiency','cosphi');
title('Efficiency and power factor versus torque');