function varargout = Ex8i_SM(varargin)
% EX8I_SM M-file for Ex8i_SM.fig
%      EX8I_SM, by itself, creates a new EX8I_SM or raises the existing
%      singleton*.
%
%      H = EX8I_SM returns the handle to a new EX8I_SM or the handle to
%      the existing singleton*.
%
%      EX8I_SM('CALLBACK',hObject,eventData,handles,...) calls the local
%      function named CALLBACK In EX8I_SM.M with the given input arguments.
%
%      EX8I_SM('Property','Value',...) creates a new EX8I_SM or raises the
%      existing singleton*.  Starting from the left, property value pairs are
%      applied to the GUI before Ex8i_SM_OpeningFunction gets called.  An
%      unrecognized property name or invalid value makes property application
%      stop.  All inputs are passed to Ex8i_SM_OpeningFcn via varargin.
%
%      *See GUI Options on GUIDE's Tools menu.  Choose "GUI allows only one
%      instance to run (singleton)".
%
% See also: GUIDE, GUIDATA, GUIHANDLES

% Edit the above text to modify the response to help Ex8i_SM

% Last Modified by GUIDE v2.5 10-Oct-2008 10:18:41

% Begin initialization code - DO NOT EDIT
gui_Singleton = 1;
gui_State = struct('gui_Name',       mfilename, ...
                   'gui_Singleton',  gui_Singleton, ...
                   'gui_OpeningFcn', @Ex8i_SM_OpeningFcn, ...
                   'gui_OutputFcn',  @Ex8i_SM_OutputFcn, ...
                   'gui_LayoutFcn',  [] , ...
                   'gui_Callback',   []);
if nargin && ischar(varargin{1})
    gui_State.gui_Callback = str2func(varargin{1});
end

if nargout
    [varargout{1:nargout}] = gui_mainfcn(gui_State, varargin{:});
else
    gui_mainfcn(gui_State, varargin{:});
end
% End initialization code - DO NOT EDIT

% --- Executes just before Ex8i_SM ik made visible.
function Ex8i_SM_OpeningFcn(hObject, eventdata, handles, varargin)
% This function has no output args, see OutputFcn.
% hObject    handle to figure
% eventdata  reserved - to be defined In a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
% varargin   command line arguments to Ex8i_SM (see VARARGIN)

% Choose default command line output for Ex8i_SM
handles.output = hObject;

% Update handles structure
guidata(hObject, handles);

if strcmp(get(hObject,'Visible'),'off')
    initialize_gui(hObject, handles);
end
set(handles.figure1,'Name','Synchronous Machine');

% UIWAIT makes Ex8i_SM wait for user response (see UIRESUME)
% uiwait(handles.figure1);


% --- Outputs from this function are returned to the command line.
function varargout = Ex8i_SM_OutputFcn(hObject, eventdata, handles)
varargout{1} = handles.output;

%-----------------------------------------------------------------------
%           ---  Input Parameters   ---
%-----------------------------------------------------------------------

function Sn_CreateFcn(hObject, eventdata, handles)
my_background(hObject);
function Sn_Callback(hObject, eventdata, handles)
n_par=1; data_in;

function Vn_CreateFcn(hObject, eventdata, handles)
my_background(hObject);
function Vn_Callback(hObject, eventdata, handles)
n_par=2; data_in;

function xd_CreateFcn(hObject, eventdata, handles)
my_background(hObject);
function xd_Callback(hObject, eventdata, handles)
n_par=3; data_in;

function xq_CreateFcn(hObject, eventdata, handles)
my_background(hObject);
function xq_Callback(hObject, eventdata, handles)
n_par=4; data_in;

function rs_CreateFcn(hObject, eventdata, handles)
my_background(hObject);
function rs_Callback(hObject, eventdata, handles)
n_par=5; data_in;

function Ve1_CreateFcn(hObject, eventdata, handles)
my_background(hObject);
function Ve1_Callback(hObject, eventdata, handles)
n_par=6; data_in;

%------------------------------------------------------------
%           ---  Output results   ---
%------------------------------------------------------------

function In_CreateFcn(hObject, eventdata, handles)
my_background(hObject);

function Zn_CreateFcn(hObject, eventdata, handles)
my_background(hObject);

function teta1_CreateFcn(hObject, eventdata, handles)
my_background(hObject);

function Id1_CreateFcn(hObject, eventdata, handles)
my_background(hObject);

function Iq1_CreateFcn(hObject, eventdata, handles)
my_background(hObject);

function P1_CreateFcn(hObject, eventdata, handles)
my_background(hObject);

function Q1_CreateFcn(hObject, eventdata, handles)
my_background(hObject);

function Pk_CreateFcn(hObject, eventdata, handles)
my_background(hObject);

function Ik_CreateFcn(hObject, eventdata, handles)
my_background(hObject);

function tetak_CreateFcn(hObject, eventdata, handles)
my_background(hObject);

function pfk_CreateFcn(hObject, eventdata, handles)
my_background(hObject);

function Imax_CreateFcn(hObject, eventdata, handles)
my_background(hObject);

function Isc3_CreateFcn(hObject, eventdata, handles)
my_background(hObject);

%------------------------------------------------------------
%           ---  Push button actions   ---
%------------------------------------------------------------

% --- Executes on button press In pushbutton1.
function pushbutton1_Callback(hObject, eventdata, handles)
din = getappdata(gcbf, 'metricdata');
dout = Ex8i_SM1(din);
set(handles.In, 'String', dout(1));
set(handles.Zn, 'String', dout(2));
set(handles.teta1, 'String', dout(3));
set(handles.Id1, 'String', dout(4));
set(handles.Iq1, 'String', dout(5));
set(handles.P1, 'String', dout(6));
set(handles.Q1, 'String', dout(7));
set(handles.Pk, 'String', dout(8));
set(handles.Ik, 'String', dout(9));
set(handles.tetak, 'String', dout(10));
set(handles.pfk, 'String', dout(11));
set(handles.Imax, 'String', dout(12));
set(handles.Isc3, 'String', dout(13));


% --- Executes on button press In pushbutton2.
function pushbutton2_Callback(hObject, eventdata, handles)
initialize_gui(gcbf, handles);

function pushbutton7_Callback(hObject, eventdata, handles)
close('Synchronous Machine');
close all;

function initialize_gui(fig_handle, handles)
din=[50000 15000 1.2 0.9 0.008 12000];
setappdata(fig_handle, 'metricdata', din);
set(handles.Sn, 'String', din(1));
set(handles.Vn, 'String', din(2));
set(handles.xd, 'String', din(3)); 
set(handles.xq, 'String', din(4));
set(handles.rs, 'String', din(5));
set(handles.Ve1, 'String', din(6));

function my_background(hObject)
if ispc
    set(hObject,'BackgroundColor','white');
else
    set(hObject,'BackgroundColor',get(0,'defaultUicontrolBackgroundColor'));
end

function dout = Ex8i_SM1(din)
Sn=din(1)*1000; Vn=din(2); x_d=din(3);
x_q=din(4); r_1=din(5); VeE=din(6);

teta=[-pi:pi/100:pi];
Vfn=Vn/sqrt(3);
Ifn=Sn/(3*Vfn);
Xb=Vfn/Ifn;
Xd=x_d*Xb;
Xq=x_q*Xb;
R1=r_1*Xb;

a=inv([Xd R1;-R1 Xq]);
Id=a(1,1)*(VeE-Vfn*cos(teta))+a(1,2)*Vfn*sin(teta);
Iq=a(2,1)*(VeE-Vfn*cos(teta))+a(2,2)*Vfn*sin(teta);
I1=sqrt(Iq.^2+Id.^2);
Ps=3*Vfn*(Iq.*cos(teta)+Id.*sin(teta));
Qs=3*Vfn*(-Iq.*sin(teta)+Id.*cos(teta));
Ss=3*Vfn*I1;
ii=find(teta>=0);
teta1=interp1(I1(ii),teta(ii),Ifn);
Id1=a(1,1)*(VeE-Vfn*cos(teta1))+a(1,2)*Vfn*sin(teta1);
Iq1=a(2,1)*(VeE-Vfn*cos(teta1))+a(2,2)*Vfn*sin(teta1);
P1=3*Vfn*(Iq1*cos(teta1)+Id1*sin(teta1));
Q1=3*Vfn*(-Iq1*sin(teta1)+Id1*cos(teta1));
Pk=max(Ps);
ii=find(Ps==Pk);
Ipk=I1(ii);
tetaPk=teta(ii);
pfk=Pk/(3*Vfn*Ipk);
Isc3=VeE*sqrt(a(1,1)^2+a(2,1)^2);

ted=teta*180/pi;
ted1=teta1*180/pi;
tedpk=tetaPk*180/pi;
dout=[Ifn Xb ted1 Id1 Iq1 P1/1000 Q1/1000 Pk/1000 Ipk tedpk pfk max(I1) Isc3];
figure
plot(ted,Id,ted,Iq,ted,I1);
grid;
legend('Id','Iq','I1');
xlabel('Internal ungle (degree)');
ylabel('Current (A)');

figure
plot(ted,Ps/1000,ted,Qs/1000,ted,Ss/1000);
grid
legend('P','Q','S');
xlabel('Internal ungle (degree)');
ylabel('Power (kW)');