% Machine magnetization curves:
% - flux versus magnetization current

Bg=[0.2:0.02:1];

% Air-gap MMF
Fg	= Bg*kC*hag*mm2m/mu_0;	%Ampere turns

% Stator tooth MMF
sBTT = Bg*tauSslot/(sf*sToothTop);	%Tesla
sBTR = Bg*tauSslot/(sf*sToothRoot);	%Tesla
sBTM = 2*Bg*tauSslot/(sf*(sToothTop+sToothRoot));
sHTT = getHx(Bref,Href,sBTT,sW3/sToothTop,sf);
sHTR = getHx(Bref,Href,sBTR,sW1/sToothRoot,sf);
sHTM = getHx(Bref,Href,sBTM,(sW1+sW3)/(sToothRoot+sToothTop),sf);
sFtooth= shOA*mm2m*(sHTT+4*sHTM+sHTR)/6;	%Ampere turns

% Roror tooth MMF
rBTT = Bg*tauRslot/(sf*rToothTop);	%Tesla fluxuri in baza dinte
rBTR = Bg*tauRslot/(sf*rToothRoot);	%Tesla
rBTM = 2*Bg*tauRslot/(sf*(rToothTop+rToothRoot));
rHTT = getHx(Bref,Href,rBTT,rW1/rToothTop,sf);
rHTR = getHx(Bref,Href,rBTR,rW2/rToothRoot,sf);
rHTM = getHx(Bref,Href,rBTM,(rW1+rW2)/(rToothRoot+rToothTop),sf);
rFtooth= rhOA*mm2m*(rHTT+4*rHTM+rHTR)/6;	%Ampere turns

% The shape factor 
KfHelper = (Fg+sFtooth+rFtooth)./Fg;
Kf_helper = [1	1.15	1.35	1.61	1.8	2	2.2	2.38 2.6];
Kf_ref = [1.5708	1.5	1.4	1.29	1.22	1.17	1.13	1.11 1.1];
ii=find(KfHelper<Kf_helper(end));
if ~isempty(ii) Kf(ii)=interp1(Kf_helper, Kf_ref, KfHelper(ii),'spline');end
    ii=find(KfHelper>=Kf_helper(end));
if ~isempty(ii) Kf(ii)=1.1; end
   
Fi0=Bg*tauPole*mm2m*lc*mm2m./Kf;

% Stator Core MMF
message=[' Stator Core'];
sBCore = Fi0/(sf*lc*mm2m*2*shy*mm2m);	%Tesla
C=getKC(sBCore, poles, message, ShowCurveReadings);	
sHc = getHx(Bref,Href,sBCore,0,sf);
sFcore = sHc*pi*(Dx*mm2m)./(poles*C);	%Ampere turns

% For the Rotor Core MMF
message=[' Rotor Core'];
rBCore = Fi0/(sf*lc*mm2m*2*rhy*mm2m);	%Tesla
C=getKC(rBCore, poles, message, ShowCurveReadings);	
rHc = getHx(Bref,Href,rBCore,0,sf);;
rFcore = rHc*pi*(Dy*mm2m)./(poles*C);	% Ampere turns
Ftot = sFcore + sFtooth + Fg + rFtooth + rFcore;
Psi0=Fi0*N1*fw;
I0=pi*poles*Ftot/(2*nphase*N1*fw);
Lm=Psi0./I0;