%	filename constant.m
%
%----Basic Material Constants--------------------
%
%	Ewen Ritchie 98-10-21
%	Institute of Energy Technology,
%	Aalborg University,
%	Denmark
%	Copyright (c) 1998 by Ewen Ritchie
%	Last Modified 99-11-14 by Tutelea Lucian
%   Poisson factor and mm2cm was added

global true false able mu_0

%-----------Material Constants--------------------------
mu_0	= 4*pi*10^(-7);		% Permeability of free space
mu_0cm=mu_0*1e2;	        %permeability of free space cm
mu_0mm=mu_0*1e3;	        %permeability of free space mm


copper_density = 8.93 * 10^3;	%kg/m^3
rho_copper = 17.25e-9;	        %ohm/m at 20 deg. C
alpha_copper = 1/235;	

aluminium_density = 5.6 * 10^3;	%kg/m^3
rho_aluminium =32.3e-9;	        %ohm/m at 20 deg. C
alpha_aluminium = 1/225;	

iron_kPoisson=0.3;		        %Poissons ratio for iron

%----------Other useful constants----------
%----------Boolean Constants---------------
true=1;TRUE=true;
false=0;FALSE=false;

able=1;	     %value for short pause

%----------Conversions---------------------
deg2rad= pi/180;
mm2thou= 1e3/25.4;
mm2m = 1e-3;
mm2cm= 1e-1;
cm2m = 1e-2;
mm2dcm = 1e-2;

%---------Three-Phase Constants------------
i = 1;					%subscript for current
v = 2;					%subscript for voltage
star = [1 1/sqrt(3)];   %star connection
delta = [sqrt(3) 1];	%delta connection
