
    cu_c=cu_pr*WeightStCu; 			%USD copper cost
    lam_c=lam_pr*WeightIronUsed; 	%USD lamination cost
    cage_c=wind2_pr*WeightCage; 	%USD costurile materialelor dion colivie
    pmw_c=pmw_pr*WeightM; 	        %USD passive material cost
    i_cost=cu_c+lam_c+cage_c+pmw_c; %USD initial cost
        
    Pcu=Pcu1+Pcu2;
    etan=Pn*1000/(Pn*1000+Pcu+Pfe+Pmec);
    
    lframe=lc+2*(lf1+lf2)+tauPole*cSpan*(1+shOA/sDi); %mm - Length of the motor frame
    Aframe=pi*sDo*lframe*kff+pi/2*sDo^2;              %mm^2 - Thermal equivalent frame area 
    Tw=(Pcu+Pfe)/(alpha_t*Aframe*1e-6)+Tamb;
   
    if(exist('eta_min','var'))
       energy_c=energy_pr*Pn*(kn1*max(0,(1/eta1-1/eta_min))+...
          (1-kn1)*max(0,(1/etan-1/eta_min)))*hpy*ny;  %USD/kWh only over energy cost
    else
       energy_c=energy_pr*Pn*(1/etan-1)*hpy*ny;       %USD/kWh energy price
    end
    
    temp_cost=max(0,(Tw-Tw_max)*kct*i_cost);
    Istart_cost=max(0,Istart/abs(I1n)-Is_max)*i_cost;
    t_cost=i_cost*ccp+energy_c+temp_cost+Istart_cost;              %USD total cost
    
    if(~isreal(t_cost))
        exit('Imaginar');
    end