%filename draw.m
%Drawing a induction machine
%Used in e7_or
%Tutelea Lucian 03.11.1999

figure
hold on;
fi=0: pi/500: 2*pi;
%Drawing the main dimension 
plot(0.5*rDi*cos(fi),0.5*rDi*sin(fi));
plot(0.5*rDo*cos(fi),0.5*rDo*sin(fi));
plot(0.5*sDi*cos(fi),0.5*sDi*sin(fi));
plot(0.5*sDo*cos(fi),0.5*sDo*sin(fi));
plot(0.5*Dx*cos(fi),0.5*Dx*sin(fi),'g');
plot(0.5*Dy*cos(fi),0.5*Dy*sin(fi),'g');

%Drawing the slots
%Describe stator slot
fi=pi/2: -pi/25 : 0;
Np_radius=length(fi);
half_Np=5;
Xs(1)=0;					Ys(1)=sMs/2;
Xs(2)=sh4;					Ys(2)=sMs/2;
Xs(3)=sh4+sh3; 			    Ys(3)=sW3/2;
Xs(4)=sh4+sh3+sh2; 		    Ys(4)=sW2/2;
Xs(5)=sh4+sh3+sh2+sh1;	    Ys(5)=sW1/2;
%Xs(6:half_Np)=Xs(5)+sR1*cos(fi); Ys(6:half_Np)=sR1*sin(fi);
Xs(half_Np+1:2*half_Np)=Xs(half_Np:-1:1);	Ys(half_Np+1:2*half_Np)=-Ys(half_Np:-1:1);	

   fi0=asin(0.5*rMs/rR1);
   fi1=(pi+rSlotAlpha)/2;
   x0=rh1+rR1*cos(fi0);
   x1=x0+rh3+(rR1-rR2)*sin(rSlotAlpha/2);
   fitop=fi0 : pi/50 : fi1;
   fibottom=fi1: pi/50 : pi;
   Np_top=length(fitop);
   Np_bottom=length(fibottom);
   half_Np=Np_top+Np_bottom+2;

   Xr(1)=0;					Yr(1)=rMs/2;
   Xr(2)=rh1;				Yr(2)=rMs/2;
   Xr(3: Np_top+2)=x0-rR1*cos(fitop); Yr(3:Np_top+2)=rR1*sin(fitop);
   Xr(Np_top+3: half_Np)=x1-rR2*cos(fibottom); Yr(Np_top+3:half_Np)=rR2*sin(fibottom);
   Xr(half_Np+1:2*half_Np)=Xr(half_Np:-1:1);	Yr(half_Np+1:2*half_Np)=-Yr(half_Np:-1:1);	
   


   for(i_slot=0: sSlots-1)
      cosA=cos(i_slot*sSlotAlpha); sinA=sin(i_slot*sSlotAlpha);
      plot((sDi/2+Xs)*cosA-Ys*sinA,(sDi/2+Xs)*sinA+Ys*cosA);
   end;   
   for(i_slot=0: rSlots-1)
      cosA=cos(i_slot*rSlotAlpha); sinA=sin(i_slot*rSlotAlpha);
      plot((rDo/2-Xr)*cosA-Yr*sinA,(rDo/2-Xr)*sinA+Yr*cosA);
   end
   title('Induction machine - Inner rotor');
   str=sprintf('%4.0f', rDi);
   tx=0.5*rDi*cos(pi/4);	ty=0.5*rDi*sin(pi/4);
   text(tx,ty, str);


str=sprintf('%4.0f', sDo);
tx=0.5*sDo*cos(pi/4);	ty=0.5*sDo*sin(pi/4);
text(tx,ty, str);
str=sprintf('%4.0f', sDi);
tx=0.5*sDi*cos(pi/4);	ty=0.5*sDi*sin(pi/4);
text(tx,ty, str);

V=axis;
str=sprintf('lc=%4.0f', lc);
tx=V(1)+0.02*(V(2)-V(1));	ty=V(4)-0.04*(V(4)-V(3));
text(tx,ty, str);

xlabel('[mm]'); ylabel('[mm]');

grid
zoom on