% Magnetic field strength computation

function Hx=getHx(Bref,Href,Bin,w2b,ks)
global mu_0

Bref1=Bref+mu_0*Href*((w2b+1)/ks-1);
ii=find(Bin>=Bref1(end));
if ~isempty(ii) Hx(ii)=Href(end)+(Bin(ii)-Bref1(end))/mu_0; end
ii=find(Bin<Bref1(end));
if ~isempty(ii) Hx(ii)=interp1(Bref1,Href,Bin(ii),'spline'); end

   