%	file function getKC.m
%
%	This file is part of the
%	Analysis of 3-ph Induction motor
%	Given B, in the core in question
%	this function returns the core path
%	shortening factor, C. C is obtained by
%	looking up the empirical curve.
%
%	Inputs: 	- flux density, number of poles
%				- message, show (if show is true, value of C is in mesage)
%  Returns: - shortening factor C.
%
%	It is directly called from:
%				getLh.m		getMMF.m
%
%	Usses: No fille are calling
%
%	This is the English Electric calculation for
%	analysis of a 3-phase, star connected
%	induction motor.
%

function C = getKC(B, poles, message, show)

%	Ewen Ritchie 98-10-26
%	Copyright (c) 1998 by Ewen Ritchie
%	Inst. of Energy Technology
%	Aalborg University
%	Last modified 98-11-09

%	Get constants
constant;
%	Get KC automatically

%	Find KC automatically, by interpolation of
%	the manual curve
B_helper = [0 0.4 0.6 0.8 1 1.2 1.4 1.6 2.05];

%	IF THERE'S A PROBLEM SOLVE IT SOMEHOW!
ii=find(B>max(B_helper));
if ~isempty(ii) B(ii)=max(B_helper);
end

if poles==2
KC_ref= [2 2 2.1 2.4 2.85 3.55 4.7 6.7 12];	%2 Pole
elseif poles == 4
KC_ref = [2 2 2 2 2.18 2.5 3.1 3.8 6];	%4 Pole
elseif poles >= 6
KC_ref = [2 2 2 2 2 2.1 2.4 2.9 4.1];	%>= 6 Poles
end;

C = interp1(B_helper, KC_ref, B, 'spline');

if show==true
fprintf([message 'KC is :' num2str(C) '\n\n']);
end;