% Get coeficients in order to compute the diferential leakage inductance
function [ro_d1, sigma_d1, sigma_d2]=getKdif(q1,zr2p,cSpan,slant);

q1Ref=[2 3 4 5 6 8];
zr2pRef=[10 15 20 25 30 35 40 45 50 60];
llim=[1 1 1 2 2 2]; rlim=[3 5  6 8 9 10];
ro_d0Ref(1,llim(1):rlim(1))=[.94 .87 .77];
ro_d0Ref(2,llim(2):rlim(2))=[.92 .87 .84 .78 .68];
ro_d0Ref(3,llim(3):rlim(3))=[.90 .81 .77 .75 .72 .67];
ro_d0Ref(4,llim(4):rlim(4))=[.78 .71 .69 .67 .65 .62 .59];
ro_d0Ref(5,llim(5):rlim(5))=[.73 .67 .62 .60 .58 .57 .55 .53];
ro_d0Ref(6,llim(6):rlim(6))=[.66 .58 .52 .49 .47 .46 .46 .44 .43];

ro_d1Ref(1,llim(1):rlim(1))=[.99 .94 .87];
ro_d1Ref(2,llim(2):rlim(2))=[.98 .93 .88 .85 .81];
ro_d1Ref(3,llim(3):rlim(3))=[.97 .90 .84 .80 .77 .74];
ro_d1Ref(4,llim(4):rlim(4))=[.86 .81 .75 .72 .70 .67 .65];
ro_d1Ref(5,llim(5):rlim(5))=[.82 .74 .70 .66 .62 .61 .60 .59];
ro_d1Ref(6,llim(6):rlim(6))=[.78 .67 .60 .56 .53 .51 .49 .48 .47];

q2Ref=[1 2 7/3 8/3 3 10/3 11/3 4];
sigma_d2Ref=[9.7 2.29 1.68 1.28 1.02 0.82 0.68 0.57]/100;

ii=find(q1Ref==q1);
if isempty(ii) error('Specificate slots per pole per phase is out of data base');
else
   if(slant<0) slant=-slant; end 
	if(slant>1) slant=1; end
   ro_dsRef=(1-slant)*ro_d0Ref(ii,:)+slant*ro_d1Ref(ii,:);   
   if(zr2p<=zr2pRef(llim(ii))) ro_d1=ro_dsRef(llim(ii));
   elseif(zr2p>=zr2pRef(rlim(ii))) ro_d1=ro_dsRef(rlim(ii));
   else ro_d1=interp1(zr2pRef(llim(ii):rlim(ii)),ro_dsRef(llim(ii):rlim(ii)),zr2p,'spline');
   end
end

ii=1:200; hsp=[6*ii-1,6*ii+1]; 
a1=pi/(6*q1); a2=cSpan*pi/2;
sigma_d1=(sin(a1)/sin(a2))^2*sum((sin(hsp*a2)./(hsp.*sin(hsp*a1))).^2);

q2=zr2p/6;
if q2<1 error('Increase the number of slots in rotor');
elseif q2>4 sigma_d2=.0915/(q2^2);
else sigma_d2=interp1(q2Ref,sigma_d2Ref,q2,'spline');
end

   
