%Primary Dimension, Technical request and Technological limitation

%Technical request
Pn=22;	 % KW  -roted power
fn=50;	 % Hz - base speed
Vfn=220; % V  - phase voltage

%Primary Dimension
poles=2;	% number of poles
nphase=3;   % number of phase
ParallelPaths=1;  % parallel current path

%Optimization variable limitations
elsp_min=12;      %kA/m	Minimum	Specificate electric load 
Bagsp_min=0.4;    %T Minimum Specificate magnetic inductin in air gap
lcpertau_min=0.5; %mm Minimum value of Core stack length
Js_min=2.5;       %A/mm^2 Minimum Stator current density
Jr_min=2;       %A/mm^2 Minimum Rotor current density
sBt_min=1.2;      %T Mimnimum Specificate magnetic inductin in stator Tooth
sBy_min=1;        %Minimum magnetic induction in rotor yoke 
rBt_min=1.2;      %T Minimum magnetic induction in stator yoke 
rBy_min=1;	  %T Minimum magnetic induction in rotor yoke 
q1_min=2;         %number of stator slots per pole per phase
sMs_min=0.5;      %mm Minimum value of Stator open width
rMs_min=0.3;      %mm - Minimum Mouth of rotor slot 
sh4_min=0.3;      %mm - Minimum stator coil height 
rh1_min=0.3;      %mm Minimum height of mouth of rotor slot
cSpan_min=0.66;   %Copil open

elsp_max=40;      %kA/m	Maximum Specificate electric load   
Bagsp_max=0.85;    %T Maximum  Specificate magnetic inductin in air gap
lcpertau_max=2;   %mm Maximum value of Core stack length
Js_max=8;         %A/mm^2 Minimum Stator current density
Jr_max=7.5;       %A/mm^2 Maximum	Rotor current density
sBt_max=2.1;      %T Maximum Specificate magnetic inductin in stator Tooth
sBy_max=2;      %T Maximum magnetic induction in stator yoke 
rBt_max=2.1;      %T Maximum  magnetic induction in stator yoke 
rBy_max=2;	  %T Maximum magnetic induction in rotor yoke 
q1_max=6;         %number of stator slots per pole per phase
sMs_max=2;        %mm Maximum value of Stator open width
rMs_max=2;        %mm Maximum Mouth of rotor slot .
sh4_max=2;        %mm - Maximum stator coil height 
rh1_max=2;        %mm Maximum height of mouth of rotor slot
cSpan_max=1;      %Copil open

%Minimum variation
dXmin=[0.2 0.01 0.05 0.05 0.05 0.02 0.02 0.02 0.02 1 0.1 0.1 0.1 0.1 0.02 1];

%Secondary data prescriptin
layers=2;

%Technological dimensions - Geometric minimum dimensions
hag=0.7;
rDi_min=52;         %mm - Mnimum shaft diameter
sW3_min=2;          %mm width of top slots
dlr=3;              %mm diferenta dintre lungimea rotorului si a 
lf1=8;              %mm - right part of overhang coils
lf2=8;              %mm - distanta bobina si scut
sf=0.97;            %stacking factor
sSlotFill=0.4;	    %slot filling factor
kJendr2Jr=0.8;
rss=0;		        % - rotor slot slant in number of rotor slot pitch  

etaSpec=0.85;        % required efficiency
cosPhiSpec=0.95;    % required power factor
Is_max=6;           %pu - mazimum value of the starting current

sAlpha=22.5;            %degrees-weangle
slotInsulThick=0.15;    % Thickness of slot insulation
slotClosureThick=0.5;   % Thickness of slot closure (wedge)

nce=1;   % number of elementary conductors
Kso=0.3;

M19;     %Magnetic material data for stator
rWm='Al';

%Objective function coefficients
cu_pr=10;     %USD/kg copper price
Al_pr=1;      %USD/kg Al price
lam_pr=5;     %USD/kg lamination price
rotIron_pr=5; %USD/kg - shaft iron price
energy_pr=0.1;%USD/kWh energy price
pmw_pr=5;     %USD/kg passive material price
hpy=1500;     %h hour per year
ny=10;        %years of use
kct=1;        %over temperature penalty cost coefficient

% Other specification
Tw1=105;      %deg. C - stator winding temperature
Tw2=125;      %deg. C - rotor winding temperature
Tw_max=155;   %deg.C - maximum winding temperature
Tamb=50;      %deg.C - temperature of cooling fluid
alpha_t=14.2; %W/m^2*deg. thermal transmission coefficient
kff=4.5;      %increasing factor of cooling surface
kpfe=2.25;    %iron losses factor (the iron loss are larger due field non-uniformity)
Pmec=12*Pn;   %W assumed mechanical losses 0.5%Pn
Pem_n=1000*Pn+Pmec;	            % W - maximum electromechanically power
run_mode='o'; % Run mode: 'o' - optimization, 'e' - performances evaluation
output_file='im1_ohg1.m';   % Name of the output file
t_file='im1_ohg1.txt';           % Name of the table output file
trace_file='im1_ohg1';	            % Name of the trace file for optimization