
% Electrical rated parameters 
Pn=22.000000;	% W  - rated power 
fn=50.000000;	% Hz - rated frequency 
Vfn=220.000000;	% V  - dc voltage 
I1n=39.491623; % A - Rated current
etan=0.938242;	 % Rated efficiency 
cosphin=0.887778; % Power factor
Pcu=837.560447;		% W - Rated copper loss 
Pfe=346.538377;		% W - Rated iron loss 
Pmec=264.000000;   % W - Mechanical loss (given in input file) 
sR=0.112985; % Ohm Stator (dc) resistance 
rR=0.079789; % Ohm Rotor (dc) resistance 
sR=372.135562; % Ohm Iron loss equivalent resistance 
Lm0_sat=0.053170; % H Magnetization inductance (at rated field) 
Lsl=0.001632; % H Stator leakage inductance 
Lrl=0.001544; % H Rotor leakage resistance 
rJ=0.074566; % kgm^2 Rotor inertia 
%Optimization variableelsp=28.000000;   % T -Specificate electric load
Bagsp=0.630000;  % T -Airgap flux density 
lcpertau=0.850000;%  Ratio of core stack length per pole pitch
Js=2.800000;     %A/mm^2 Stator current density
Jr=2.200000;    % A/m^2 Rotor current density
sBt=2.460000;    % T - Flux density in stator Tooth 
sBy=1.740000;    % T - Flux density in stator Yoke 
rBt=2.340000;    % T - Flux density in rotor Tooth 
rBy=1.840000;    % T - Flux density in rotor Yoke 
sh4=0.800000;    % mm - Top of stator teeth height 
sMs=1.400000;    % mm - Stator slot open width 
rMs=1.200000;    % mm - Rotor slot open width 
rh1=0.500000;    % mm - Top of rotor teeth height 
q1=5.000000;     % Number of stator slots per pole per phase
cSpan=0.733333;  % pu - Coil open 
rSlots=18.000000  % Number of Rotor slots 

% Constructive dimensions 
sDo=273.000000;	% mm - Stator outer diameter 
sDi=155.954343;	% mm - Stator inner diameter 
lc=192.221931;     % mm - Core length 
hag=0.650000;    % mm - air-gap 
shOA=30.458409;   % mm - Total stator sloth height 
sh4=0.800000;	% mm - Stator tooth pole tip height- fig.3.1
sh3=2.260901;	% mm - Stator wedge place height - fig.3.1
sh1=26.747508;	% mm - Stator coil height 
shy=28.064420;	% mm - Stator yoke width 
swp=4.182457;	% mm - Stator tooth width 
sW1=18.075783;	% mm - Stator slot width (root)
sW2=12.453230;	% mm - Stator coil width (top)
sMs=1.400000;	% mm - Stator slot mouth 
sBareD;    % mm - Diameter of stator equivalent bare 
R1=81.038072;	    % mm - Radius of tooth head  
N1=60.000000;		% Turns per coil 
rDo=154.654343;	% mm - Rotor outer diameter 
rDi=52.000000;	% mm - Rotor inner diameter
rhy=26.698705;	% mm - Rotor yoke width 
rhOA=24.539922;   % mm - Total rotor sloth height 
rh2=8.156883;	% mm - height of botom part of rotor bar 
rh3=10.708803;	% mm -  
rW1=16.109329;	% mm - widith of rotor bar at bottom 
rW2=12.332827;	% mm - widith of top rotor bar 

% Weights
WeightStCu=23.867740;	% kg - 
WeightStTeethIron=6.173410;	% kg - 
WeightStCoreIron=31.407046;	% kg - 
WeightStIron=37.580456;	% kg - 
WeightSt=61.448196;	% kg - 
WeightRtBare=6.270793;	% kg - 
WeightRtRing=0.890604;	% kg -  
WeightCage=7.161397;		% kg -  
WeightRtTeethIron=6.100742;	% kg -  
WeightRtCoreIron=9.600126;		% kg - 
WeightRtIront=15.700868;	% kg - 
WeightRt=22.862265;	% kg - 
WeightM=84.310461;	% kg - 
WeightIronUsed=108.391336;	% kg - 

% Costs
cu_c=238.677402		% USD Copper cost
lam_c=541.956678	% USD Lamination cost
cage_c=7.161397		% USD 
pmw_c=421.552307	% USD passive material cost
i_cost=1209.347784 	% USD initial cost
energy_c=2172.148237 % USD energy loss cost
t_cost=3381.496021	% USD total cost


 % -------------------------------------------------------------------------------


		 %This outputs was produced using the next data as input:
%Primary Dimension, Technical request and Technological limitation

%Technical request
Pn=22;	 % KW  -roted power
fn=50;	 % Hz - base speed
Vfn=220; % V  - phase voltage

%Primary Dimension
poles=2;	% number of poles
nphase=3;   % number of phase
ParallelPaths=1;  % parallel current path

%Optimization variable limitations
elsp_min=12;      %kA/m	Minimum	Specificate electric load 
Bagsp_min=0.4;    %T Minimum Specificate magnetic inductin in air gap
lcpertau_min=0.5; %mm Minimum value of Core stack length
Js_min=2.5;       %A/mm^2 Minimum Stator current density
Jr_min=2;       %A/mm^2 Minimum Rotor current density
sBt_min=1.2;      %T Mimnimum Specificate magnetic inductin in stator Tooth
sBy_min=1;        %Minimum magnetic induction in rotor yoke 
rBt_min=1.2;      %T Minimum magnetic induction in stator yoke 
rBy_min=1;	  %T Minimum magnetic induction in rotor yoke 
q1_min=2;         %number of stator slots per pole per phase
sMs_min=0.5;      %mm Minimum value of Stator open width
rMs_min=0.3;      %mm - Minimum Mouth of rotor slot 
sh4_min=0.3;      %mm - Minimum stator coil height 
rh1_min=0.3;      %mm Minimum height of mouth of rotor slot
cSpan_min=0.66;   %Copil open

elsp_max=40;      %kA/m	Maximum Specificate electric load   
Bagsp_max=0.85;    %T Maximum  Specificate magnetic inductin in air gap
lcpertau_max=2;   %mm Maximum value of Core stack length
Js_max=8;         %A/mm^2 Minimum Stator current density
Jr_max=7.5;       %A/mm^2 Maximum	Rotor current density
sBt_max=2.1;      %T Maximum Specificate magnetic inductin in stator Tooth
sBy_max=2;      %T Maximum magnetic induction in stator yoke 
rBt_max=2.1;      %T Maximum  magnetic induction in stator yoke 
rBy_max=2;	  %T Maximum magnetic induction in rotor yoke 
q1_max=6;         %number of stator slots per pole per phase
sMs_max=2;        %mm Maximum value of Stator open width
rMs_max=2;        %mm Maximum Mouth of rotor slot .
sh4_max=2;        %mm - Maximum stator coil height 
rh1_max=2;        %mm Maximum height of mouth of rotor slot
cSpan_max=1;      %Copil open

%Minimum variation
dXmin=[0.2 0.01 0.05 0.05 0.05 0.02 0.02 0.02 0.02 1 0.1 0.1 0.1 0.1 0.02 1];

%Secondary data prescriptin
layers=2;

%Technological dimensions - Geometric minimum dimensions
hag=0.65;
rDi_min=52;         %mm - Mnimum shaft diameter
sW3_min=2;          %mm width of top slots
dlr=3;              %mm diferenta dintre lungimea rotorului si a 
lf1=8;              %mm - right part of overhang coils
lf2=8;              %mm - distanta bobina si scut
sf=0.97;            %stacking factor
sSlotFill=0.4;	    %slot filling factor
kJendr2Jr=0.8;
rss=0;		        % - rotor slot slant in number of rotor slot pitch  

etaSpec=0.85;        % required efficiency
cosPhiSpec=0.95;    % required power factor
Is_max=6;           %pu - mazimum value of the starting current

sAlpha=22.5;            %degrees-weangle
slotInsulThick=0.15;    % Thickness of slot insulation
slotClosureThick=0.5;   % Thickness of slot closure (wedge)

nce=1;   % number of elementary conductors
Kso=0.3;

M19;     %Magnetic material data for stator
rWm='Al';

%Objective function coefficients
cu_pr=10;     %USD/kg copper price
Al_pr=1;      %USD/kg Al price
lam_pr=5;     %USD/kg lamination price
rotIron_pr=5; %USD/kg - shaft iron price
energy_pr=0.1;%USD/kWh energy price
pmw_pr=5;     %USD/kg passive material price
hpy=1500;     %h hour per year
ny=10;        %years of use
kct=1;        %over temperature penalty cost coefficient

% Other specification
Tw1=105;      %deg. C - stator winding temperature
Tw2=125;      %deg. C - rotor winding temperature
Tw_max=155;   %deg.C - maximum winding temperature
Tamb=50;      %deg.C - temperature of cooling fluid
alpha_t=14.2; %W/m^2*deg. thermal transmission coefficient
kff=4.5;      %increasing factor of cooling surface
kpfe=2.25;    %iron losses factor (the iron loss are larger due field non-uniformity)
Pmec=12*Pn;   %W assumed mechanical losses 0.5%Pn
Pem_n=1000*Pn+Pmec;	            % W - maximum electromechanically power
run_mode='o'; % Run mode: 'o' - optimization, 'e' - performances evaluation
output_file='im1_oga2.m';   % Name of the output file
t_file='im1_oga2.txt';           % Name of the table output file
trace_file='im1_oga2';	            % Name of the trace file for optimization