
% Electrical rated parameters 
Pn=22.000000;	% W  - rated power 
fn=50.000000;	% Hz - rated frequency 
Vfn=220.000000;	% V  - dc voltage 
I1n=38.976842; % A - Rated current
etan=0.932110;	 % Rated efficiency 
cosphin=0.900071; % Power factor
Pcu=945.724530;		% W - Rated copper loss 
Pfe=392.651645;		% W - Rated iron loss 
Pmec=264.000000;   % W - Mechanical loss (given in input file) 
sR=0.109112; % Ohm Stator (dc) resistance 
rR=0.117600; % Ohm Rotor (dc) resistance 
sR=333.191625; % Ohm Iron loss equivalent resistance 
Lm0_sat=0.056823; % H Magnetization inductance (at rated field) 
Lsl=0.001469; % H Stator leakage inductance 
Lrl=0.001484; % H Rotor leakage resistance 
rJ=0.077216; % kgm^2 Rotor inertia 
%Optimization variableelsp=27.400000;   % T -Specificate electric load
Bagsp=0.625000;  % T -Airgap flux density 
lcpertau=0.949775;%  Ratio of core stack length per pole pitch
Js=3.490646;     %A/mm^2 Stator current density
Jr=3.664667;    % A/m^2 Rotor current density
sBt=2.100000;    % T - Flux density in stator Tooth 
sBy=1.731733;    % T - Flux density in stator Yoke 
rBt=1.856905;    % T - Flux density in rotor Tooth 
rBy=1.500546;    % T - Flux density in rotor Yoke 
sh4=1.210856;    % mm - Top of stator teeth height 
sMs=1.218302;    % mm - Stator slot open width 
rMs=1.122112;    % mm - Rotor slot open width 
rh1=1.192592;    % mm - Top of rotor teeth height 
q1=4.000000;     % Number of stator slots per pole per phase
cSpan=0.833333;  % pu - Coil open 
rSlots=18.000000  % Number of Rotor slots 

% Constructive dimensions 
sDo=256.000000;	% mm - Stator outer diameter 
sDi=148.935908;	% mm - Stator inner diameter 
lc=239.613351;     % mm - Core length 
hag=0.700000;    % mm - air-gap 
shOA=26.853196;   % mm - Total stator sloth height 
sh4=1.210856;	% mm - Stator tooth pole tip height- fig.3.1
sh3=2.649327;	% mm - Stator wedge place height - fig.3.1
sh1=22.343012;	% mm - Stator coil height 
shy=26.678850;	% mm - Stator yoke width 
swp=5.802281;	% mm - Stator tooth width 
sW1=20.064560;	% mm - Stator slot width (root)
sW2=14.181533;	% mm - Stator coil width (top)
sMs=1.218302;	% mm - Stator slot mouth 
sBareD;    % mm - Diameter of stator equivalent bare 
R1=78.328137;	    % mm - Radius of tooth head  
N1=48.000000;		% Turns per coil 
rDo=147.535908;	% mm - Rotor outer diameter 
rDi=52.000000;	% mm - Rotor inner diameter
rhy=31.017021;	% mm - Rotor yoke width 
rhOA=16.531476;   % mm - Total rotor sloth height 
rh2=6.912402;	% mm - height of botom part of rotor bar 
rh3=3.163713;	% mm -  
rW1=13.659547;	% mm - widith of rotor bar at bottom 
rW2=12.543851;	% mm - widith of top rotor bar 

% Weights
WeightStCu=20.238416;	% kg - 
WeightStTeethIron=7.569433;	% kg - 
WeightStCoreIron=34.844838;	% kg - 
WeightStIron=42.414270;	% kg - 
WeightSt=62.652686;	% kg - 
WeightRtBare=4.395497;	% kg - 
WeightRtRing=0.408595;	% kg -  
WeightCage=4.804092;		% kg -  
WeightRtTeethIron=6.352294;	% kg -  
WeightRtCoreIron=14.665418;		% kg - 
WeightRtIront=21.017712;	% kg - 
WeightRt=25.821804;	% kg - 
WeightM=88.474490;	% kg - 
WeightIronUsed=118.811172;	% kg - 

% Costs
cu_c=202.384159		% USD Copper cost
lam_c=594.055860	% USD Lamination cost
cage_c=4.804092		% USD 
pmw_c=442.372451	% USD passive material cost
i_cost=1243.616561 	% USD initial cost
energy_c=2403.564263 % USD energy loss cost
t_cost=3647.180824	% USD total cost


 % -------------------------------------------------------------------------------


		 %This outputs was produced using the next data as input:
%Primary Dimension, Technical request and Technological limitation

%Technical request
Pn=22;	 % KW  -roted power
fn=50;	 % Hz - base speed
Vfn=220; % V  - phase voltage

%Primary Dimension
poles=2;	% number of poles
nphase=3;   % number of phase
ParallelPaths=1;  % parallel current path

%Optimization variable limitations
elsp_min=12;      %kA/m	Minimum	Specificate electric load 
Bagsp_min=0.4;    %T Minimum Specificate magnetic inductin in air gap
lcpertau_min=0.5; %mm Minimum value of Core stack length
Js_min=2.5;       %A/mm^2 Minimum Stator current density
Jr_min=2;       %A/mm^2 Minimum Rotor current density
sBt_min=1.2;      %T Mimnimum Specificate magnetic inductin in stator Tooth
sBy_min=1;        %Minimum magnetic induction in rotor yoke 
rBt_min=1.2;      %T Minimum magnetic induction in stator yoke 
rBy_min=1;	  %T Minimum magnetic induction in rotor yoke 
q1_min=2;         %number of stator slots per pole per phase
sMs_min=0.5;      %mm Minimum value of Stator open width
rMs_min=0.3;      %mm - Minimum Mouth of rotor slot 
sh4_min=0.3;      %mm - Minimum stator coil height 
rh1_min=0.3;      %mm Minimum height of mouth of rotor slot
cSpan_min=0.66;   %Copil open

elsp_max=40;      %kA/m	Maximum Specificate electric load   
Bagsp_max=0.85;    %T Maximum  Specificate magnetic inductin in air gap
lcpertau_max=2;   %mm Maximum value of Core stack length
Js_max=8;         %A/mm^2 Minimum Stator current density
Jr_max=7.5;       %A/mm^2 Maximum	Rotor current density
sBt_max=2.1;      %T Maximum Specificate magnetic inductin in stator Tooth
sBy_max=2;      %T Maximum magnetic induction in stator yoke 
rBt_max=2.1;      %T Maximum  magnetic induction in stator yoke 
rBy_max=2;	  %T Maximum magnetic induction in rotor yoke 
q1_max=6;         %number of stator slots per pole per phase
sMs_max=2;        %mm Maximum value of Stator open width
rMs_max=2;        %mm Maximum Mouth of rotor slot .
sh4_max=2;        %mm - Maximum stator coil height 
rh1_max=2;        %mm Maximum height of mouth of rotor slot
cSpan_max=1;      %Copil open

%Minimum variation
dXmin=[0.2 0.01 0.05 0.05 0.05 0.02 0.02 0.02 0.02 1 0.1 0.1 0.1 0.1 0.02 1];

%Secondary data prescriptin
layers=2;

%Technological dimensions - Geometric minimum dimensions
hag=0.7;
rDi_min=52;         %mm - Mnimum shaft diameter
sW3_min=2;          %mm width of top slots
dlr=3;              %mm diferenta dintre lungimea rotorului si a 
lf1=8;              %mm - right part of overhang coils
lf2=8;              %mm - distanta bobina si scut
sf=0.97;            %stacking factor
sSlotFill=0.4;	    %slot filling factor
kJendr2Jr=0.8;
rss=0;		        % - rotor slot slant in number of rotor slot pitch  

etaSpec=0.85;        % required efficiency
cosPhiSpec=0.95;    % required power factor
Is_max=6;           %pu - mazimum value of the starting current

sAlpha=22.5;            %degrees-weangle
slotInsulThick=0.15;    % Thickness of slot insulation
slotClosureThick=0.5;   % Thickness of slot closure (wedge)

nce=1;   % number of elementary conductors
Kso=0.3;

M19;     %Magnetic material data for stator
rWm='Al';

%Objective function coefficients
cu_pr=10;     %USD/kg copper price
Al_pr=1;      %USD/kg Al price
lam_pr=5;     %USD/kg lamination price
rotIron_pr=5; %USD/kg - shaft iron price
energy_pr=0.1;%USD/kWh energy price
pmw_pr=5;     %USD/kg passive material price
hpy=1500;     %h hour per year
ny=10;        %years of use
kct=1;        %over temperature penalty cost coefficient

% Other specification
Tw1=105;      %deg. C - stator winding temperature
Tw2=125;      %deg. C - rotor winding temperature
Tw_max=155;   %deg.C - maximum winding temperature
Tamb=50;      %deg.C - temperature of cooling fluid
alpha_t=14.2; %W/m^2*deg. thermal transmission coefficient
kff=4.5;      %increasing factor of cooling surface
kpfe=2.25;    %iron losses factor (the iron loss are larger due field non-uniformity)
Pmec=12*Pn;   %W assumed mechanical losses 0.5%Pn
Pem_n=1000*Pn+Pmec;	            % W - maximum electromechanically power
run_mode='o'; % Run mode: 'o' - optimization, 'e' - performances evaluation
output_file='im1_ohg1.m';   % Name of the output file
t_file='im1_ohg1.txt';           % Name of the table output file
trace_file='im1_ohg1';	            % Name of the trace file for optimization