gen=1:length(t_cost_best);     
if(exist('gx')==1)
    xname='Generation';

    figure
    plot(gen,c_min,'o',gen,c_max,'*',gen,c_med,'.');
    grid
    legend('cost min','cost max','cost med');   
    xlabel('Generation');
    ylabel('Cost function');
else
    xname='steps';
end

figure
subplot(1,2,1);
plot(gen,sDo_best,'o',gen,sDi_best,'*',gen,rDo_best,'.',gen,rDi_best,'^');
grid
legend('Dso','Dsi','Dro','Dri');   
xlabel(xname);
ylabel('(mm)');
title('Main dimension');

subplot(1,2,2);
[backgr,map]=imread('im1.gif');
image(backgr)
colormap(map)
axis off

figure
subplot(1,2,1);
plot(gen,sh1_best,'o',gen,sh3_best,'*',gen,sh4_best,'.',gen,shOA_best,'^');
grid
legend('hs1','hs3','hs4','shOA');   
xlabel(xname);
ylabel('(mm)');
title('Stator slot dimension');

subplot(1,2,2);
[backgr,map]=imread('imsslot.gif');
image(backgr)
colormap(map)
axis off

%figure
%plot(gen,sW1_best,'o',sW3_best,'*',sMs_best,'.');
%grid
%legend('sW1','sW3','oss');
%xlabel(xname);
%ylabel('(mm)');
%title('Stator slot dimension');

figure
subplot(1,2,1);
plot(gen,rh1_best,'o',gen,rh2_best,'*',gen,rh3_best,'.',gen,rh4_best,'^');
grid
legend('hr1','hr2','hr3','hr4');
xlabel(xname);
ylabel('(mm)');
title('Rotor slot dimension');

subplot(1,2,2);
[backgr,map]=imread('imrslot.gif');
image(backgr)
colormap(map)
axis off

%figure
%plot(gen,rW1_best,'o',rW3_best,'*',rMs_best,'.');
%grid
%legend('rW1','rW3','ors');
%xlabel(xname);
%ylabel('(mm)');
%title('Stator slot dimension');

figure
plot(gen,Pcu_best,'o',gen,Pfe_best,'*',gen,Pmec_best,'.');
grid
legend('Pcu','Pfe','Pmec');
xlabel(xname);
ylabel('Power (W)');
title('Power losses');

figure
plot(gen,etan_best,'o',gen,pfn_best,'.');
legend('etan','Power factor');
grid
xlabel(xname);
ylabel('Efficiency');
  
figure
plot(gen,WeightM_best,'o',gen,WeightSt_best,'*',gen,WeightRt_best,'.');
grid
legend('Total','Stator','Rotor'); 
xlabel(xname);
ylabel('Weight (kg)');

figure
plot(gen,WeightStCu_best,'o',gen,WeightCage_best,'*',gen,WeightRtBare_best,'.',gen,WeightRtRing_best,'+');
grid
legend('Stator Coils','Cage','Cage Bare','Cage Ring');   
xlabel(xname);
ylabel('Weight (kg)');
   
figure
plot(gen,WeightStIron_best,'o',gen,WeightStTeethIron_best,'*',gen,WeightRtIron_best,'.',...
    gen,WeightRtTeethIron_best,'^',gen,WeightIronUsed_best,'+');
grid
legend('Stator Iron','Stator Teeth','Rotor Iron','Rotor Teeth','Total Used Iron');
xlabel(xname);
ylabel('Weight (kg)');
   
figure
plot(gen,cu_c_best,'o',gen,lam_c_best,'*',gen,cage_c_best,'.');
grid
legend('copper','iron','cage');
xlabel(xname);
ylabel('Material cost (USD)');

 
figure
plot(gen,pmw_c_best,'o',gen,i_cost_best,'*',gen,energy_c_best,'.',gen,t_cost_best,'+');
grid
legend('weight','initial','energy','total');
xlabel(xname);
ylabel('Component cost (USD)');

figure
plot(gen,Xbest(:,1),'o');
grid;
xlabel(xname);
ylabel('(kA/m)');
title('Specific electric load');

figure
plot(gen,Xbest(:,2),'o',gen,Xbest(:,6),'*',gen,Xbest(:,7),'.',gen,Xbest(:,8),'^',gen,Xbest(:,9),'+');
grid;
legend('Air-gap','Stator tooth', 'Stator yoke','Rotor tooth','Rotor yoke');
xlabel(xname);
ylabel('Flux density (T)');
title('Specific flux density');

figure
plot(gen,Xbest(:,4),'o',gen,Xbest(:,5),'.');
grid;
xlabel(xname);
legend('stator','rotor');
ylabel('(A/mm^2)');
title('Current density');

figure
plot(gen,Xbest(:,3),'o',gen,Xbest(:,15),'.');
grid;
xlabel(xname);
legend('core length to pole pitch','coil span to pole pitch');

figure
plot(gen,3*Xbest(:,10)*poles,'o',gen,Xbest(:,16),'.');
xlabel(xname);
legend('stator','rotor');
title('Number of slots');
grid

if(exist('gx')==1)
    member=1:np;
    figure
    plot(member,costm,'o')
    grid
    xlabel('member');
    ylabel('Cost function');
    title('Last generation');

    for ii=1:np
        Xlast(ii,:)=Xmin+gx(ii,:).*dXmin;
        Z1=rot_slots(poles/2,Xlast(ii,10));
        Xlast(ii,16)=Z1(1+mod(Xlast(ii,16)-1,length(Z1)));
    end
 
    figure
    plot(member,Xlast(:,1),'o');
    grid;
    xlabel('member');
    ylabel('(kA/m)');
    title('Specific electric load');

    figure
    plot(member,Xlast(:,2),'o',member,Xlast(:,6),'*',member,Xlast(:,7),'.',member,Xlast(:,8),'^',member,Xlast(:,9),'+');
    grid;
    legend('Air-gap','Stator tooth', 'Stator yoke','Rotor tooth','Rotor yoke');
    xlabel('member');
    ylabel('Flux density (T)');
    title('Specific flux density');

    figure
    plot(member,Xlast(:,4),'o',member,Xlast(:,5),'.');
    grid;
    xlabel('member');
    legend('stator','rotor');
    ylabel('(A/mm^2)');
    title('Current density');

    figure
    plot(member,Xlast(:,3),'o',member,Xlast(:,15),'.');
    grid;
    xlabel('member');
    legend('core length to pole pitch','coil span to pole pitch');

    figure
    plot(member,3*Xlast(:,10)*poles,'o',member,Xlast(:,16),'.');
    xlabel('member');
    legend('stator','rotor');
    title('Number of slots');
    grid
end