if(rss==0) fwr=1;			% Winding factor for squirrel-cage motor
 else fwr = sin(rss*tauRslot*pi/(2*tauPole))/(rss*tauRslot*pi/(2*tauPole));
end   

% Resistances
rho1=rho_copper*(1+(Tw1-20)*alpha_copper);
sR0 =rho1*MLC*mm2m*CPhY/(wireCSA*ParallelPaths);
rBar = rho2*(1+(Tw2-20)* alpha_rho2)*lrc*mm2m/(rSlotArea*mm2m^2);
kRing2bar=1/(2*sin(0.5*poles*pi/rSlots));
rRings = rho2*(1+(Tw2-20)* alpha_rho2)*2*pi*rEndRingMeanD*(kRing2bar^2)/(rSlots*rEndRingCSA*mm2m);
rR = (rBar + rRings)*4*nphase*((N1*fw/fwr)^2)/rSlots;

% Carter's Coefficient - to allow for slotting effects at the air-gap
g1=(sMs/hag)^2/(5+sMs/hag); kC1=tauSslot/(tauSslot-g1*hag);
g2=(rMs/hag)^2/(5+rMs/hag); kC2=tauRslot/(tauRslot-g2*hag);
kC=kC1*kC2;

% Inductances
if cSpan>1, k2=(3*(2-cSpan)+1)/4;
 elseif cSpan>0.6666, k2=(1+3*cSpan)/4;
 else k2=(6*cSpan-1)/4;
end
k1=(1+3*k2)/4;
b1=(sW1+sW2)^2/(0.25*(3*sW1+sW2)+0.5*sW1^2*(sW2-3*sW1)/(sW1-sW2)^2+...
    sW1^4*log(sW1/sW2)/((sW1-sW2)^3));
b2=(sW2-sW3)/log(sW2/sW3);
b3=(sW3-sMs)/log(sW3/sMs);
sh=[sh4, sh3, sh2];
sw=[sMs, b3, b2];

lamda_ss=sh1*k1/b1+k2*sum(sh./sw);						% stator slot permeance
lamda_sO=0.34*q1*(sOverhangLength-0.64*(sDi+shOA)/poles*cSpan)/lc; %end-coil permeance - Boldea Handbook of IM
lamda_rs=pi/6 + 2*rh3/(3*(rW1+rW2)) + rh1/rMs;		% rotor slot permeance
lamda_rO	= 2.3*rEndRingMeanD*(kRing2bar^2)/(rSlots*lrc)*log(4.7*rEndRingMeanD/(2*wEndRing+rhRing)); % rotor end ring permeance
k01=1-0.033*sMs^2/(hag*tauSslot);
k02=1-0.033*rMs^2/(hag*tauRslot);
[ro_d1, sigma_d1, sigma_d2]=getKdif(q1,2*rSlots/poles,cSpan,rss);
lamda_sd=0.3*ro_d1*k01*sigma_d1*tauSslot*(q1*fw)^2/(kC*hag);
lamda_rd=0.3*k02*sigma_d2*tauRslot*(rSlots/(3*poles)*fwr)^2/(kC*hag);
Lsl=2*mu_0*N1^2*lc*mm2m*(lamda_ss+lamda_sd+lamda_sO)/(0.5*poles*q1);    	% stator leakage inductance
Lrl=4*nphase*mu_0*(N1*fw)^2*lrc*mm2m*(lamda_rs+lamda_rd+lamda_rO)/rSlots; % rotor leakage inductance
Lm0=2*nphase*mu_0*(N1*fw/pi)^2*lc*mm2m*tauPole/(0.5*poles*kC*hag);

% Overhang leakage inductance 
Lsew=2*mu_0*N1^2*lc*mm2m*lamda_sO/(0.5*poles*q1);  % end coil leakage inductance 
