fid=fopen(output_file,'w');
fprintf(fid,'\n%% Electrical rated parameters \n');
fprintf(fid,'Pn=%f;	%% W  - rated power \n', Pn);
fprintf(fid,'fn=%f;	%% Hz - rated frequency \n', fn);
fprintf(fid,'Vfn=%f;	%% V  - dc voltage \n', Vfn);
fprintf(fid,'I1n=%f; %% A - Rated current\n', abs(I1n));
fprintf(fid,'etan=%f;	 %% Rated efficiency \n', etan);
fprintf(fid,'cosphin=%f; %% Power factor\n', cos(angle(I1n)));
fprintf(fid,'Pcu=%f;		%% W - Rated copper loss \n', Pcu);
fprintf(fid,'Pfe=%f;		%% W - Rated iron loss \n', Pfe);
fprintf(fid,'Pmec=%f;   %% W - Mechanical loss (given in input file) \n',Pmec); 

fprintf(fid,'sR=%f; %% Ohm Stator (dc) resistance \n', sR0);
fprintf(fid,'rR=%f; %% Ohm Rotor (dc) resistance \n', rR);
fprintf(fid,'sR=%f; %% Ohm Iron loss equivalent resistance \n', Rfe);
fprintf(fid,'Lm0_sat=%f; %% H Magnetization inductance (at rated field) \n', Lm0_sat);
fprintf(fid,'Lsl=%f; %% H Stator leakage inductance \n', Lsl);
fprintf(fid,'Lrl=%f; %% H Rotor leakage resistance \n', Lrl);
fprintf(fid,'rJ=%f; %% kgm^2 Rotor inertia \n', rJ);

fprintf(fid,'%%Optimization variable');
fprintf(fid,'elsp=%f;   %% T -Specificate electric load\r\n',elsp);
fprintf(fid,'Bagsp=%f;  %% T -Airgap flux density \n',Bagsp);
fprintf(fid,'lcpertau=%f;%%  Ratio of core stack length per pole pitch\n', lcpertau);
fprintf(fid,'Js=%f;     %%A/mm^2 Stator current density\n',Js);
fprintf(fid,'Jr=%3f;    %% A/m^2 Rotor current density\n',Jr);
fprintf(fid,'sBt=%f;    %% T - Flux density in stator Tooth \n',sBt);
fprintf(fid,'sBy=%f;    %% T - Flux density in stator Yoke \n',sBy);
fprintf(fid,'rBt=%f;    %% T - Flux density in rotor Tooth \r\n',rBt);
fprintf(fid,'rBy=%f;    %% T - Flux density in rotor Yoke \n',rBy);
fprintf(fid,'sh4=%f;    %% mm - Top of stator teeth height \n',sh4);
fprintf(fid,'sMs=%f;    %% mm - Stator slot open width \n', sMs);
fprintf(fid,'rMs=%f;    %% mm - Rotor slot open width \r\n', rMs);
fprintf(fid,'rh1=%f;    %% mm - Top of rotor teeth height \r\n',rh1);
fprintf(fid,'q1=%f;     %% Number of stator slots per pole per phase\n',q1);
fprintf(fid,'cSpan=%f;  %% pu - Coil open \n',cSpan);
fprintf(fid,'rSlots=%f  %% Number of Rotor slots \n',rSlots); 

fprintf(fid,'\n%% Constructive dimensions \n');
fprintf(fid,'sDo=%f;	%% mm - Stator outer diameter \n', sDo);
fprintf(fid,'sDi=%f;	%% mm - Stator inner diameter \n', sDi);
fprintf(fid,'lc=%f;     %% mm - Core length \n', lc);
fprintf(fid,'hag=%f;    %% mm - air-gap \n', hag);
fprintf(fid,'shOA=%f;   %% mm - Total stator sloth height \n',shOA);
fprintf(fid,'sh4=%f;	%% mm - Stator tooth pole tip height- fig.3.1\n',sh4);
fprintf(fid,'sh3=%f;	%% mm - Stator wedge place height - fig.3.1\n',sh3);
fprintf(fid,'sh1=%f;	%% mm - Stator coil height \n', sh1);
fprintf(fid,'shy=%f;	%% mm - Stator yoke width \n', shy);
fprintf(fid,'swp=%f;	%% mm - Stator tooth width \n', swp);
fprintf(fid,'sW1=%f;	%% mm - Stator slot width (root)\n', sW1);
fprintf(fid,'sW2=%f;	%% mm - Stator coil width (top)\n', sW2);
fprintf(fid,'sMs=%f;	%% mm - Stator slot mouth \n', sMs);
fprintf(fid,'sBareD;    %% mm - Diameter of stator equivalent bare \n', sBareD);
fprintf(fid,'R1=%f;	    %% mm - Radius of tooth head  \n', sDi/2+sh3+sh4);
fprintf(fid,'N1=%f;		%% Turns per coil \n', N1);

fprintf(fid,'rDo=%f;	%% mm - Rotor outer diameter \n', rDo);
fprintf(fid,'rDi=%f;	%% mm - Rotor inner diameter\n', rDi);
fprintf(fid,'rhy=%f;	%% mm - Rotor yoke width \n', rhy);
fprintf(fid,'rhOA=%f;   %% mm - Total rotor sloth height \n',rhOA);
fprintf(fid,'rh2=%f;	%% mm - height of botom part of rotor bar \n', rh2);
fprintf(fid,'rh3=%f;	%% mm -  \n', rh3);
fprintf(fid,'rW1=%f;	%% mm - widith of rotor bar at bottom \n', rW1);
fprintf(fid,'rW2=%f;	%% mm - widith of top rotor bar \n', rW2);

fprintf(fid,'\n%% Weights\n');
fprintf(fid,'WeightStCu=%f;	%% kg - \n', WeightStCu);
fprintf(fid,'WeightStTeethIron=%f;	%% kg - \n', WeightStTeethIron);
fprintf(fid,'WeightStCoreIron=%f;	%% kg - \n', WeightStCoreIron);
fprintf(fid,'WeightStIron=%f;	%% kg - \n', WeightStIron);
fprintf(fid,'WeightSt=%f;	%% kg - \n', WeightSt);
fprintf(fid,'WeightRtBare=%f;	%% kg - \n', WeightRtBare);
fprintf(fid,'WeightRtRing=%f;	%% kg -  \n', WeightRtRing);
fprintf(fid,'WeightCage=%f;		%% kg -  \n', WeightCage);
fprintf(fid,'WeightRtTeethIron=%f;	%% kg -  \n', WeightRtTeethIron);
fprintf(fid,'WeightRtCoreIron=%f;		%% kg - \n', WeightRtCoreIron);
fprintf(fid,'WeightRtIront=%f;	%% kg - \n', WeightRtIron);
fprintf(fid,'WeightRt=%f;	%% kg - \n', WeightRt);
fprintf(fid,'WeightM=%f;	%% kg - \n', WeightM);
fprintf(fid,'WeightIronUsed=%f;	%% kg - \n',WeightIronUsed);

fprintf(fid,'\n%% Costs\n');
fprintf(fid,'cu_c=%f		%% USD Copper cost\n', cu_c);
fprintf(fid,'lam_c=%f	%% USD Lamination cost\n', lam_c);
fprintf(fid,'cage_c=%f		%% USD \n',cage_c);
fprintf(fid,'pmw_c=%f	%% USD passive material cost\n',pmw_c);
fprintf(fid,'i_cost=%f 	%% USD initial cost\n',i_cost);
fprintf(fid,'energy_c=%f %% USD energy loss cost\n',energy_c);
fprintf(fid,'t_cost=%f	%% USD total cost\n',t_cost);

fprintf(fid,'\n\n %% -------------------------------------------------------------------------------\n');
fprintf(fid,'\n\n\t\t %%This outputs was produced using the next data as input:\n');

fid2=fopen([f_input,'.m'],'r');
while 1
	[line,lt]=fgets(fid2);
	if ~isstr(line), break, end
	fprintf(fid,'%s',line);
end
fclose(fid2);

fclose(fid);