%sdims.m - Secondary dimension computed from primary dimension
lc=tauPole*lcpertau;                     %mm - stator core length
fip=2*lc*tauPole*mm2m^2*Bagsp/pi;        %Wb
N1=Vfn/(sqrt(2)*pi*fn*fw*fip);           %Turns per phase
sb_c=2*N1*ParallelPaths/(poles*q1*layers);        %turns per coil
sb=round(sb_c);
if (sb==0) sb=1; 
end
N1=0.5*poles*q1*sb*layers/ParallelPaths;
lc=sb_c*lc/sb;

%------------------------------------------
% Secondary stator slot dimensions
sSlotAlpha=2*pi/sSlots;	             %rad - mechanical angle between two stator slots
sMsAlpha2=asin(sMs/sDi);             %rad -half of sMs angle
sTeethAlpha=max(sSlotAlpha/2-sMsAlpha2,asin(swp/sDi)); %rad - half
sMsAlpha2=sSlotAlpha/2-sTeethAlpha;
sMs=sDi*sin(sMsAlpha2);              %mm - Stator slot mouth           
Aria_Cu=pi*sDi*elsp/sSlots/Js;
Aslots=Aria_Cu/sSlotFill;
sh2=slotInsulThick+slotClosureThick;     %in this case as winding fills slot
sh3=(sW3-sMs)/2*tan(sAlpha*deg2rad);
sW2=sW3+2*sh2*tan(sSlotAlpha/2);         %mm width at top of winding 
sh1=(-sW2+sqrt(sW2^2+4*Aslots*tan(sSlotAlpha/2)))/(2*tan(sSlotAlpha/2));
shOA=sh4+sh3+sh2+sh1;    %mm overall slot height 
sW1=sW3+2*(sh2+sh1)*tan(sSlotAlpha/2);	%mm - Stator slot width (root)
sSlotArea=(sh4*sMs)+sh3*(sMs+sW3)/2+sh2*(sW3+sW2)/2+sh1*(sW2+sW1)/2;
sSlotWindingArea=(sh1-slotInsulThick)*(sW2+sW1-4*slotInsulThick)/2;

shy=Bagsp*tauPole/(sBy*pi);              %mm Stator bare diameter
sDo=sDi+2*shOA+2*shy;    %mm - stator outside dismeter
sDo=round(sDo);
shy=(sDo-sDi)/2-shOA;
lrc=lc+dlr;		        % mm - rotor core length
rSlotArea=(rh1*rMs)+(rR1+rR2)*sqrt(rh3^2-(rR1-rR2)^2)+0.5*((pi+rSlotAlpha)*rR1^2+(pi-rSlotAlpha)*rR2^2);

%----------Overhang Dimension---------------
sOverhangLength =pi/2*tauPole*cSpan*(1+shOA/sDi)+2*lf1;
lff=2*lf1+tauPole*cSpan*(1+shOA/sDi)+lc;

%	Rotor End Ring & factors
Ier=Irb/(2*sin(0.5*pi*poles/rSlots));
Jendring=kJendr2Jr*Jr;
rEndRingCSA =Ier/Jendring;        %mm^2
rhRing = round(0.5+rhOA); %mm radial ring height 

%-----------Short Circuit Ring----------------
rEndRingMeanD=rDo-2*rh1-rhRing;
wEndRing=rEndRingCSA/rhRing;

%---------------------------------------------
%	Other secondary dimensions and factors
lcEff=lc*sf;	%mm effective iron core length 
rEndRingMeanD = ((rDo-2*rh1) + (rDo-2*rhOA))/2; %mm


%---------Winding Details-------------------
CpS=sb*layers;	%Conductors per slot
CPhY=CpS*(sSlots/(nphase*ParallelPaths));	%Conductors per phase
MLC =  sOverhangLength + lc;	   %mm Length of the mean conductor 
sBareD=2*sqrt((Aria_Cu/CpS)/pi); % mm diameter of stator equivalent bare
wireCSA = ((pi*sBareD^2)/4)*1e-6;  %m^2 Wire CSA 
dce=sBareD/sqrt(nce);
m1=sh1/sqrt(0.5*(sW1+sW2)*sh1/(sb*nce)); %elementary conductors layers 

%---------------------------------------------
%	effective diameter for estimating
%	core path magnetic length
% stator
Dx = sDo - (2/3)*(sDo - (sDi+(2*shOA)));	% Corrected 99-10-18 AER
%	rotor
Dy = (rDo - (2*rhOA))- (1/3)*((rDo - (2*rhOA))-rDi);

%---------------------------------------------
% Stator tooth dimensions
sToothRoot=tauSslot*(sDi+(2*shOA))/sDi-sW1;%width at tooth root
sToothTop=tauSslot*(sDi+(2*(sh3+sh4)))/sDi-sW3;%width nearest air-gap
%	Rotor tooth dimensions
rToothTop = 2*((rDo/2-rh1-rR1)*sin(rSlotAlpha/2)-rR1);    %mm width at tooth top
rToothRoot= 2*((rDo/2-rh1-rR1-rh3)*sin(rSlotAlpha/2)-rR2);%width at tooth root


%---------Winding Weight--------------------
WeightStCu=CPhY*ParallelPaths*nphase*wireCSA*MLC*copper_density*1e-3;	%kg

%----------- Iron weights & volumes ----------------
%	Total usage
WeightIronUsed = (sDo*mm2m)^2*lcEff*mm2m*iron_density; % kg

%	For estimation of iron loss
WeightStCoreIron = pi*(((sDo*mm2m)^2-((sDi+(2*shOA))*mm2m)^2)/4)...
   *lcEff*mm2m*iron_density; %	kg
VolStCoreIron = pi*(((sDo*mm2dcm)^2-((sDi+(2*shOA))*mm2dcm)^2)/4)...
   *lcEff*mm2dcm; %	Dcm^3
WeightStTeethIron = sSlots*0.5*(sToothTop+sToothRoot)*mm2m...
                    	*shOA*mm2m*lcEff*mm2m*iron_density; % kg
VolStTeethIron =sSlots*0.5*(sToothTop+sToothRoot)*mm2dcm...
                    	*shOA*mm2dcm*lcEff*mm2dcm; % Dcm^3

WeightStIron=WeightStCoreIron+WeightStTeethIron;	%kg Stator iron weight
WeightSt=WeightStIron+WeightStCu;		%Kg

%Weight of rotor
rDaux=rDi+2*rhy;
WeightRtCoreIron = 0.25*pi*(rDaux^2-rDi^2)*lcEff*iron_density*1e-9; % kg
VolRtCoreIron =  0.25*pi*(rDaux^2-rDi^2)*lcEff*1e-6; % Dcm^3
VolRtTeethIron = (pi*((rDo-rhOA)*rhOA)-rSlots*rSlotArea)*lcEff*1e-6; % Dcm^3
WeightRtTeethIron = VolRtTeethIron *iron_density*1e-3;
WeightRtIron=WeightRtCoreIron+WeightRtTeethIron;	%kg Stator iron weight
WeightRtBare=rSlots*(rSlotArea-rMs*rh1)*lc*wind2_density*1e-9;
WeightRtRing=2*rhOA*rEndRingMeanD*rhRing*wind2_density*1e-9;
WeightCage=WeightRtBare+WeightRtRing;
WeightRt=WeightRtIron+WeightCage;
WeightM=WeightSt+WeightRt;
rJ=0.125*((rDi^2+rDaux^2)*WeightRtCoreIron+(rDaux^2+rDo^2)*(WeightRtTeethIron+WeightRtBare)+...
   ((rDo-2*rh1)^2 + (rDo-2*rh1-2*rhRing)^2)*WeightRtRing)*1e-6;