%Ordinary magnetic steel;

lamThick=0.47;	        % mm - Lamination thickness
iron_density = 7.8e3;	% kg/m^3
rho_iron = 0.5263e-6   ;	    % ohm/m at 20 deg. C
alpha_iron = 1/1e10;	


%------------BH curve----------------------------------------
%	15-03-2004
%	These values are originate from Vector field default material

Bref=[0 0.64 0.92 1.01 1.1 1.2 1.3 1.4 1.45 1.5 1.55 1.575 1.6...
      1.65 1.7 1.75 1.8 1.85 1.9 1.95 2.0 2.05 2.1...
      2.15 2.2 2.25 2.3];

Href=[0 79.6 135.3 159 191 239 318 493 645 875 1273 1592 2149.0...
      3342 4775 6525 9151 11937 15120 18545 22282 27454 35810.0...
      47746 63662 93901 127324];

%------------Iron Loss----------------------------------------
%kloss=358e-6; % means 358W/kg at 1 T and 1 kHz for M19 0.5mm thick lamination
pfe10=2.5; %W/kg la 1 T si 50 Hz
%	For hysteresis loss
khloss_vol=178.478; %W/m^3 f*B^2
%	For eddy current loss
%kcloss_vol=1.41304;  % (f*B)^2 - depends on the lamination thickness
keloss_vol=1.79322;  % (f*B)^1.5   
% khloss,kcloss,keloss  from ELEKTRONIKA IR ELEKTROTECHNIKA, 
% DOI: 10.5755/j01.eee.18.9.2797 , ISSN 1392-1215, VOL. 18, NO. 9, 2012

%------------Thermal---------------------------------------------
Fetcond=23; %W/(m K)    - Thermal conductivity
Sheat=451;  %J/(kg*K) 
%---------------Conversions-------------------------------------
Fesheat=Sheat*iron_density *1e-6; %MJ/(m^3*K) 
lamThick=lamThick/1000;	% mm to metres

kloss=[khloss_vol pi^2*lamThick^2/(6*rho_iron) keloss_vol]/iron_density;