% 'Outer Boundary' should be defined outer of function
% 'frame' should be defined outer of function

function add_frame(Nb,hb, gb, poles, poles1,Rso,hframe)
alpha_b=2*pi/Nb;
alpha_b0=alpha_b/2;
Nb1=Nb/poles*poles1;
Rframe=Rso+hframe;
xb0=sqrt(Rframe^2-gb^2/4)+[0 hb hb 0];
yb0=gb/2*[-1 -1 1 1];
xprev=Rframe;
yprev=0;
alpbaBw2=asin(gb/(2*Rframe));
seg_angle=180/Nb-alpbaBw2;
hi_addnode(xprev,yprev)
for ib=1:Nb1
    alpha=ib*alpha_b-alpha_b0;
    xb=xb0*cos(alpha)-yb0*sin(alpha);
    yb=xb0*sin(alpha)+yb0*cos(alpha);
    xg=(xb(1:3)+xb(2:4))/2;
    yg=(yb(1:3)+yb(2:4))/2;
    hi_drawpolyline([xb',yb']);
    if(ib==1)
        hi_addarc(xprev,yprev,xb(1),yb(1),seg_angle,2)
    else
        hi_addarc(xprev,yprev,xb(1),yb(1),2*seg_angle,2)
    end
    for ii=1:3
        hi_selectsegment(xg(ii),yg(ii));
    end
    hi_setsegmentprop('Outer Boundary', gb, 1, 1, 0, 'none')
    hi_clearselected
    alpha_gs=atan((yprev+yb(1))/(xprev+xb(1)));
    hi_selectarcsegment(Rframe*cos(alpha_gs),Rframe*sin(alpha_gs));
    hi_setarcsegmentprop(2,'Outer Boundary',0,1,'none');
    hi_clearselected
    
    xprev=xb(4);
    yprev=yb(4);
end
alpha_f=2*pi/poles*poles1;

xf=Rframe*cos(alpha_f);
yf=Rframe*sin(alpha_f);
hi_addnode(xf,yf)
hi_addarc(xprev,yprev,xf,yf,seg_angle,2)
alpha_gs=atan((yprev+yf)/(xprev+xf));

hi_selectarcsegment(Rframe*cos(alpha_gs),Rframe*sin(alpha_gs));
hi_setarcsegmentprop(2,'Outer Boundary',0,1,'none');

hi_addsegment(Rso,0,Rframe,0)
hi_addsegment(Rso*cos(alpha_f),Rso*sin(alpha_f),xf,yf)

xgf=(Rso+hframe/2)*cos(alpha_f/2);
ygf=(Rso+hframe/2)*sin(alpha_f/2);

hi_addblocklabel(xgf,ygf); % Airgap
hi_selectlabel(xgf,ygf);
hi_setblockprop('frame',1,hframe/2,2)
hi_clearselected;

