function [ Mem, Vs] = cmecIct(Is, n, p1, psipm, Ld, Lq, Rs,teta )
%cmecVct torque versus internal angle at constant voltage
%   constant parameter are assumed
%   three phase machine

w1=pi*p1*n/30;
xd=w1*Ld;
xq=w1*Lq;
Vpm=w1*psipm;

Id=Is*cos(teta);
Iq=Is*sin(teta);
Mem=3*p1*(psipm+(Ld-Lq)*Id).*Iq;
Vs=sqrt((Vpm+xd*Id+Rs*Iq).^2+(xq*Iq-Rs*Id).^2);
end