function [ Mem, Is] = cmecVct(Vs, n, p1, psipm, Ld, Lq, Rs,teta )
%cmecVct torque versus internal angle at constant voltage
%   constant parameter are assumed
%   three phase machine

w1=pi*p1*n/30;
xd=w1*Ld;
xq=w1*Lq;
Vpm=w1*psipm;
delta=xd*xq-Rs*2;
Id0=-Vpm*xq/delta;
Iq0=-Vpm*Rs/delta;

Id=Vs/delta*(xq*cos(teta)+Rs*sin(teta))+Id0;
Iq=Vs/delta*(Rs*cos(teta)+xd*sin(teta))+Iq0;
Mem=3*p1*(psipm+(Ld-Lq)*Id).*Iq;
Is=sqrt(Id.^2+Iq.^2);

end