%	filename constant.m
%
%----Basic Material Constants--------------------
%
%  Last Modified 2016-06-2012 by Tutelea Lucian

global mu_0

%-----------Material Constants--------------------------
mu_0	= 4*pi*10^(-7);		% Permeability of free space
mu_0mm=mu_0*1e3;	%permeability of free space mm


copper_density = 8.93 * 10^3;	% kg/m^3
rho_copper = 17.25e-9;	% ohm/m at 20 deg. C
alpha_copper = 1/235;	%
cutCond=401; %W/(m*K) - thermal conductivity
cuheat=3.45; %MJ/(m^3*K) -from https://en.wikipedia.org/wiki/Table_of_specific_heat_capacities

aluminium_density = 2.71 * 10^3;	% kg/m^3
rho_aluminium =32.3e-9;	% ohm/m at 20 deg. C
alpha_aluminium = 1/225;	%
Altcond=236; %W/(m*K) - thermal conductivity
Alheat=2.422; %MJ/(m^2*K)

iron_kPoisson=0.3;		%Poissons ratio for iron

%----------Other useful constants----------
sigma0_ref=[9.66 2.84 1.41 0.89 0.65 0.52 0.44 0.38;...
            9.66 2.35 1.15 0.74 0.55 0.45 0.38 0.34;...
            nan  2.84 1.11 0.62 0.44 0.35 0.30 0.28;...
            nan  nan  1.41 0.69 0.41 0.29 0.24 0.21;...
            nan  nan  nan  0.89 0.50 0.31 0.22 0.18;...
            nan  nan  nan  nan  0.65 0.4  0.26 0.18;...
            nan  nan  nan  nan  nan  0.52 0.34 0.23;...
            nan  nan  nan  nan  nan  nan  0.44 0.30;...
            nan  nan  nan  nan  nan  nan  nan  0.38]/100;
    %[1] - Toma Dordea & all, Electrical Machines - Fortran Programs,
    %Editura Politehnica, page 23
%----------Conversions---------------------
deg2rad= pi/180;
rad2deg=180/pi;
mm2thou= 1e3/25.4;
TCK=273.15; % 0 Celsius on Kelvin
mm2m = 1e-3;