% Objective function (Cost) evaluation 
cu_c=cu_pr*mcu;           %USD copper cost
lam_c=lam_pr*used_iron;   %USD lamination cost
PM_c=PM_pr*mpm;             %USD PM cost

pmw_c=pmw_pr*mmot;  %USD passive material cost
mot_cost=cu_c+lam_c+PM_c+pmw_c; %USD initial cost
energy_c=energy_pr*P1*max(0,1/eta1-1/eta_min)/1000*hpy*ny; %USD/kWh energy price
 
teta_sn=nphase/2*sb0*q1*sqrt(2)*In0; % armature peak mmf at overload current
teta_pm=Hc*hpm*mm2m;           % PM mmf
Bdemag=mu_0*(teta_pm-ksdemag*teta_sn)/(2*(hag+hpm)*mm2m);
demag_cost=max(0,1-Bdemag/Bpmdemag)*kcdemag*mot_cost;
overtemp_cost=max(0,(Twcomp-Tw1)*kcthermal*mot_cost);
 
%dpc_cost=Pn/etan*max(0,1/cosphin-1.4)*pconv*1e-3;  %penalty due to poor power factor
t_cost=mot_cost+energy_c+demag_cost+overtemp_cost; %USD total cost