%interface with FEMM 4.2
alpha_p1=2*pi*poles1/poles;
eval('closefemm',';'); %restart femm if it is already open 
openfemm;
newdocument(0);
phase_name='ABC';
w_q1=ones(1,q1);
w_name=phase_name([w_q1 3*w_q1 2*w_q1 w_q1 3*w_q1 2*w_q1]);
w_sign=[w_q1 -w_q1 w_q1 -w_q1 w_q1 -w_q1];
%{
rb=Dsi/2+[0 0.5 1]*hs;
xb(4)=(Dso-hsy)/2*cos(alphas); % coordinate for yoke losses
yb(4)=(Dso-hsy)/2*sin(alphas);
xb(1:3)=rb*cos(2*alphas);    % coordinate for teeth losses
yb(1:3)=rb*sin(2*alphas);    
%}

%Seting the material
mi_probdef(0,'millimeters','planar',1e-8,lstack,25);
mi_getmaterial('Air');

if(stcore_fem)
    %try mi_getmaterial(stcore_fem); catch stcore_fem=0; end
    eval('mi_getmaterial(stcore_fem)', 'stcore_fem=0');
end
if(~exist('cbh_ext','var'))
    cbh_ext=0;
end

if(~stcore_fem)
    stcore_fem=stcore_mat;
    mi_addmaterial(stcore_fem,1,1,0,0,1e-6/rho_ironst,lamThick*1000,0,ssf,0);
    if(cbh_ext)
         BHs_ext= bh_extend( BHs_ref );
         mi_addbhpoints(stcore_fem,BHs_ext(1,:),BHs_ext(2,:));
    else
        mi_addbhpoints(stcore_fem,BHs_ref(1,:),BHs_ref(2,:));
    end
end
if(rtcore_mat==stcore_mat), rtcore_fem=stcore_fem; end

    if(strcmp(rtcore_mat,shaft_mat)), shaft_fem=rtcore_fem; 
    elseif(strcmp(stcore_mat,shaft_mat)), shaft_fem=stcore_fem; 
    end
    if(~(strcmp(shaft_fem,stcore_fem)||strcmp(rtcore_fem,shaft_fem)))
        if(~shaft_fem)
            mi_addmaterial(shaft_fem,1,1,0,0,1e-6/rho_ironrt,RlamThick,0,1,0);
            if(cbh_ext)
                BHsh_ext= bh_extend( BHsh_ref );
                mi_addbhpoints(shaft_fem,BHsh_ext(1,:),BHsh_ext(2,:));
            else
                mi_addbhpoints(shaft_fem,BHsh_ref(1,:),BHsh_ref(2,:));
            end
        else
            mi_getmaterial(shaft_fem);
        end
   end
[khc, mur_pme]=pmEchiv(mu_pm/mu_0,hpm/bhpm,lpm/blpm);
mi_addmaterial(pm_material,mur_pme,mur_pme,Hc*khc,0,1/(rho_pm*1e6));
mi_addmaterial('cond',1,1,0,0,1e-6/rho1,0,0,0,4,0,0,nce,dco1);
mi_addcircprop('A',0,1);
mi_addcircprop('B',0,1);
mi_addcircprop('C',0,1);

%Deffine the boundary
if(rem(poles1,2))
    simetry=5; %antyperiodic
else
    simetry=4; %periodic
end
mi_addboundprop('Zero',0,0,0,0,0,0,0,0,0);
%-------------------------------------------------
%The geometry
xf=[0 Rri Rpmi Rpmo Rro Rag Rsi Rso];
n_bound=length(xf);
for ii=1:n_bound
    mi_addboundprop(['Sim',num2str(ii)],0,0,0,0,0,0,0,0,simetry);
end

yf=zeros(size(xf));
xf2=xf*cos(alpha_p1);
yf2=xf*sin(alpha_p1);

c_alphap1=cos(alpha_p1/2);
s_alphap1=sin(alpha_p1/2);
xgf=xf(1:n_bound-1)+diff(xf)/2;
xgf2=xf2(1:n_bound-1)+diff(xf2)/2;
ygf2=yf2(1:n_bound-1)+diff(yf2)/2;

if(poles~=poles1)
    mi_drawpolyline([xf',yf']);
    mi_drawpolyline([xf2',yf2']);
   

    mi_addarc(xf(2),yf(2),xf2(2),yf2(2),360/poles*poles1,1);
    mi_addarc(xf(n_bound-3),yf(n_bound-3),xf2(n_bound-3),yf2(n_bound-3),360/poles*poles1,1);
    mi_addarc(xf(n_bound-2),yf(n_bound-2),xf2(n_bound-2),yf2(n_bound-2),360/poles*poles1,1);
    mi_addarc(xf(n_bound),yf(n_bound),xf2(n_bound),yf2(n_bound),360/poles*poles1,1);
    mi_selectarcsegment(xf(2)*c_alphap1,xf(2)*s_alphap1);
    mi_selectarcsegment(xf(n_bound-3)*c_alphap1,xf(n_bound-3)*s_alphap1);
    mi_setarcsegmentprop(2,'none',0,1);
    mi_clearselected
    
    %Boundary condition
    mi_selectarcsegment(Rso*c_alphap1,Rso*s_alphap1);
    mi_setarcsegmentprop(5,'Zero',0,0);
    mi_clearselected;
    bgr=ones(1,n_bound-1); %group alocation for the border
    bgr(n_bound-2:n_bound-1)=0;
    for ii=1:n_bound-1
        mi_selectsegment(xgf(ii),0);
        mi_selectsegment(xgf2(ii),ygf2(ii));
        mi_setsegmentprop(['Sim',num2str(ii)],Rso/25,0,0,bgr(ii));
        mi_clearselected
    end
else
    mi_addnode(xf(n_bound-1),0);
    for ii=0:6
       if(ii==0 || ii==2 || ii==3 || ii==6)
            mi_drawarc(xf(n_bound-ii),0,-xf(n_bound-ii),0,180,1);
            mi_addarc(-xf(n_bound-ii),0,xf(n_bound-ii),0,180,1);
            mi_selectarcsegment(0,xf(n_bound-ii));
            mi_selectarcsegment(0,-xf(n_bound-ii));
            if(ii)
                mi_setarcsegmentprop(2,'none',0,1);
            else
                 mi_setarcsegmentprop(5,'Zero',0,0);
            end
            mi_clearselected;
        end
    end
end

% Rotor geometry
ypm=bhpm/2*[-1 -1 1 1];
xgpm(poles1+1)=0;ygpm(poles1+1)=0;
xpm=sqrt([Rpmi^2 Rpmo^2 Rpmo^2 Rpmi^2]-bhpm^2/4);
mi_drawline(xpm(3),ypm(3),xpm(4),ypm(4));
mi_addarc(Rpmo,0,xpm(3),ypm(3),atand(ypm(3)/Rpmo),2);
mi_addarc(Rpmi,0,xpm(4),ypm(4),atand(ypm(4)/Rpmi),2);
xpmc=xpm*cos(alphap)-ypm*sin(alphap);
ypmc=xpm*sin(alphap)+ypm*cos(alphap);
wrp1=sqrt((xpm(4)-xpmc(1))^2+(ypm(4)-ypmc(1))^2);
for ii=1:poles1
    mi_drawline(xpmc(1),ypmc(1),xpmc(2),ypmc(2));
    if(ii<poles1)
        mi_drawline(xpmc(3),ypmc(3),xpmc(4),ypmc(4));
        mi_addarc(xpmc(2),ypmc(2),xpmc(3),ypmc(3),2*atand(ypm(3)/Rpmo),2);
        mi_addarc(xpmc(1),ypmc(1),xpmc(4),ypmc(4),2*atand(ypm(4)/Rpmi),2);
        ii1=ii+1;
        xgpm(ii1)=mean(xpmc);
        ygpm(ii1)=mean(ypmc);
        xpmc=xpm*cos(ii1*alphap)-ypm*sin(ii1*alphap);
        ypmc=xpm*sin(ii1*alphap)+ypm*cos(ii1*alphap);
     else
        mi_addarc(xpmc(2),ypmc(2),xf2(4),yf2(4),atand(ypm(3)/Rpmo),2);
        mi_addarc(xpmc(1),ypmc(1),xf2(3),yf2(3),atand(ypm(4)/Rpmi),2);
        xgpm(poles1+1)=(xpmc(1)+xpmc(2)+xf2(4)+xf2(3))/4;
        ygpm(poles1+1)=(ypmc(1)+ypmc(2)+yf2(4)+yf2(3))/4;
    end
    if(wrp1/2*cos(pi/poles)>hrb2max)
        if(ii==1)
            xrb(1:2)=xpm(1)-hrb2*sin(pi/poles)+[0 hrbarrier*cos(pi/poles)];
            yrb(1:2)=bhpm/2+hrb2+[0 0];
            xrb(3:4)=fliplr(xrb(1:2)*cos(alphap)+yrb(1:2)*sin(alphap));
            yrb(3:4)=fliplr(xrb(1:2)*sin(alphap)-yrb(1:2)*cos(alphap));
        else
            xrb1=xrb;
            xrb=xrb*cos(alphap)-yrb*sin(alphap);
            yrb=xrb1*sin(alphap)+yrb*cos(alphap);
        end
        mi_drawpolygon([xrb' yrb']);
        xbl=mean(xrb);
        ybl=mean(yrb);
        mi_addblocklabel(xbl,ybl); % Airgap
        mi_selectlabel(xbl,ybl);
        mi_setblockprop('Air',1,0.5,'none',0,1,0)
        mi_clearselected;
    end
end

%The rotor Material settings
xgpm(1)=(Rpmi+Rpmo+xpm(3)+xpm(4))/4;
ygpm(1)=(ypm(3)+ypm(4))/4;

for ii=1:poles1+1
    mi_addblocklabel(xgpm(ii),ygpm(ii)); %Permanent Magnet
    mi_selectlabel(xgpm(ii),ygpm(ii));
    mi_setblockprop(pm_material,1,hpm/3,'none',(ii-1)*360/poles-90+180*rem(ii,2),1,0);
    mi_clearselected;
end

xbl=xgf(1)*c_alphap1;
ybl=xgf(1)*s_alphap1;
mi_addblocklabel(xbl,ybl); %shaft
mi_selectlabel(xbl,ybl);
mi_setblockprop(shaft_fem,1,0.5,'none',0,1,0)
mi_clearselected;

x0rc=(Rri+hry/2)*c_alphap1;
y0rc=(Rri+hry/2)*s_alphap1;
mi_addblocklabel(x0rc,y0rc); % Rotor yoke
mi_selectlabel(x0rc,y0rc);
mi_setblockprop(rtcore_fem,1,0.5,'none',0,1,0)
mi_clearselected;

%The airgap Material settings
xbl=xgf(n_bound-3)*c_alphap1;
ybl=xgf(n_bound-3)*s_alphap1;
mi_addblocklabel(xbl,ybl); % Airgap
mi_selectlabel(xbl,ybl);
mi_setblockprop('Air',1,0.5,'none',0,0,0)
mi_clearselected;

xbl=xgf(n_bound-2)*c_alphap1;
ybl=xgf(n_bound-2)*s_alphap1;
mi_addblocklabel(xbl,ybl); % Airgap
mi_selectlabel(xbl,ybl);
mi_setblockprop('Air',1,0.5,'none',0,2,0)
mi_clearselected;

% stator geometry
  
xs1=xs0+[0 hs4 hs4+hs3 hs hs hs4+hs3 hs4 0]; %horizontal slot x coordinates
ys1=[-sMs -sMs -wsi -wso wso wsi sMs sMs]/2; % vertical slot y coordinates

    nps=length(xs1);  %number of point per slot
ns1=3*q1*poles1; % number of slots simulated
alphassd=360*atan(sMs/Dsi)/pi; %degree - slot oppening angle
xsp=xf(n_bound-1);
ysp=yf(n_bound-1);
alphastd1=180/Nss-alphassd/2;
alphastd=alphastd1;
for ii=1:ns1
    sina=sin((2*ii-1)*alphas);
    cosa=cos((2*ii-1)*alphas);
    xs=xs1*cosa-ys1*sina;
    ys=xs1*sina+ys1*cosa;
    mi_drawpolyline([xs',ys']);
    mi_addarc(xsp,ysp,xs(1),ys(1),alphastd,2);
    %mi_addarc(xs(1),ys(1),xs(nps),ys(nps),alphassd,2);
    mi_addsegment(xs(3),ys(3),xs(nps-2),ys(nps-2));
    xsp=xs(nps);
    ysp=ys(nps);
    alphastd=2*alphastd1;
%{    
    xbl=(Dsi+sMs)/2*cosa;
    ybl=(Dsi+sMs)/2*sina;
    mi_addblocklabel(xbl,ybl); % Stator oppening
    mi_selectlabel(xbl,ybl);
    mi_setblockprop('Air',1,0.5,'none',0,0,0)
    mi_clearselected;
%}    
    xbl=(Dsi+hs)/2*cosa;
    ybl=(Dsi+hs)/2*sina;
    mi_addblocklabel(xbl,ybl); % Stator slot
    mi_selectlabel(xbl,ybl);
    mi_setblockprop('cond',1,0.5,w_name(ii),0,0,w_sign(ii)*sb0)
    mi_clearselected;
end
mi_addarc(xsp,ysp,xf2(n_bound-1),yf2(n_bound-1),alphastd1,2);

xbl=(Dso-hsy)/2*c_alphap1;
ybl=(Dso-hsy)/2*s_alphap1;
mi_addblocklabel(xbl,ybl); % Stator yoke
mi_selectlabel(xbl,ybl);
mi_setblockprop(stcore_fem,1,0.5,'none',0,0,0)
mi_clearselected;

mi_saveas([fem_filex,'.fem']);

%---------------------------------------------
 mi_setcurrent('A',Iphase_in(1));
 mi_setcurrent('B',Iphase_in(2));
 mi_setcurrent('C',Iphase_in(3));
 
 mi_analyze(0); %flag 0 - visible windows, 0 hide windows

 %Data extraction from the 2nd simulation
 mi_loadsolution;

 xb=[Rsi Rsi+hs/2 Rsi+hs 0]*cos(2*alphas); 
 yb=[Rsi Rsi+hs/2 Rsi+hs 0]*sin(2*alphas);
 xb(4)=(Rso-hsy/2)*cos(alphas);
 yb(4)=(Rso-hsy/2)*sin(alphas);
 Bxy=mo_getb(xb,yb);
 psiabc(3)=0;
 for ii=1:3,
     rfemm=mo_getcircuitproperties(phase_name(ii));
     psiabc(ii)=rfemm(3)*poles/poles1;
 end
 mo_groupselectblock(1);
 Tfem=mo_blockintegral(22)*poles/poles1;