Pn=5000.000000;     % W - rated power 
fn=200.000000;     % Hz - base speed
Vfn=230.000000;     % V - rated voltage
pp=5;     % numbers of poles


% Electrical parameters 
Rs=0.675165; % Ohm - main phase resistance at Tw=100.000000 
N1=145.000000;     %  - turns on main winding 
psipm0=0.007111; % Wb - permanent magnet linkage flux

% Test point results
Tp1=11.936621;      %Nm - test torque 
n1=2000.000000;    % rpm -test speed 
P1=2500.000000;   %W test power
Ip1=5.908164;    % A  - phase current at test point (rms) 
Pcup1=70.702772;   % W  - copper losses 
Pfe1=39.074229;   % W  - iron losses 
eta1=0.957936;  %   - test point efficiency 

% Base speed results
Tn=19.894368;    % Nm  - rated torque
In=10.420641;    % A  - phase rated current (rms)
Pcun=219.948115;   % W  - copper losses 
Pfen=50.615577;   % W  - iron losses 
etan=0.948665;  %   - rated efficiency 
cosphin=0.738498; % - rated power factor 

% Constructive dimensions 
Dso=145.000000;    %mm - stator outer diameter 
lstack=75.500000;    %mm - motor axial length 
Rso=72.500000;    %mm - stator outer Radious 
Rsi=51.000000;    %mm - stator inner Radious 
Dri=32.000000;    % mm Rotor inner (shaft) diameter 
hpm=3.450000;    % mm PM height 
hry=3.000000;    % mm rotor yoke height 

% Stator slots dimensions
sMs=3.000000;    % mm - stator slots opening 
hs4=1.000000;    % mm - height of stator tooth tip 
hs3=1.000000;    % mm - wedge height  
swi=5.186611;    % mm slot small base width 
swo=8.150212;    % mm slot large base width 
shl=14.098390;    % mm slot height - main part 
sht=16.098390;    % mm total slot height
hsy=5.300000;    % mm stator yoke height 
wtooth=5.922949; % mm stator tooth width 

% Windings details
N1=145;    % turns per phase 
q1=1;    % coils per phase 
sb=29;    % turns per coil 
dco=1.290000;    % mm - diameter of winding wire 

% Weights
mcu=1.352734;     % kg - copper mass 
mpm=0.530496;     % kg - permanent magnet mass 
msteeth=2.187794; % kg - stator teeth mass 
msyoke=0.938381; % kg - stator yoke mass 
msiron=3.126175; % kg - stator iron mass 
mriron=3.509390; % kg - rotor iron mass 
mmot=8.518796;    % kg - motor mass 
mVol=1.246731;    % liter - motor volume (without end connections) 
Tn2m=2.335350;    % Nm/kg - torque mass density 
Tn2mVol=15.957223; % Nm/liter - torque volume density 

% Objective function
cu_c=9.739683;   % USD - copper cost
lam_c=15.600844;  % USD - lamination cost 
PM_c=26.524820;   % USD - PM cost 
pmw_c=8.280269;  % USD - weight penalty cost (frame) 
mot_cost=60.145617;   % USD - motor cost 
t_sim=[325.905517 

 % -------------------------------------------------------------------------------


	 %This outputs was produced using the next data as input:
% Claw pole external rotor PM motor 
% Input data file
 
Pn=5000;    %W - rated power
nn=2400;   %RPM  - base speed
Pnmax=5000; %W   - power at maximum speed
nmax=4800; %RPM - maximum speed
P1=2500;    %W   - test power
n1=2000;   %RPM - efficiency test speed
eta_min=0.94; %   minimum required efficiency at test power
Vfn=230;   %V - rated phase voltage (rms)
poles=10;  %  - numbers of poles
nphase=3; %number of phase
q1=1;     %number of slot per pol per phase 

% Optimization variable
Dro=100; %mm Stator outer diameter
lstack=75;%mm axial length 
hpm=4.5; %mm PM height
lpm_pu=0.9;%length of PM height in pu from maximum available space  
hsy_pu=0.15; %stator yoke height in pu from pole pitch
wt_pu=0.4; %tooth width in pu (from slot pitch)
hs_pu=1; %slot hight in pu (from slot pitch) 
  
% Optimization variable max
Dro_max=120; %mm
lstack_max=100;%mm
hpm_max=6; %mm
lpmpu_max=1; %length of PM height in pu from maximum available space  
hsypu_max=0.25; %stator yoke height in pu from pole pitch
wtpu_max=0.6; %tooth width in pu (from slot pitch)
hspu_max=1.5; %slot hight in pu (from slot pitch)
 
% Optimization variable min
Dro_min=80; %mm
lstack_min=24;%mm
hpm_min=3; %mm
lpmpu_min=0.5; %length of PM height in pu from maximum available space   
hsypu_min=0.1; %stator yoke height in pu from pole pitch
wtpu_min=0.35; %tooth width in pu (from slot pitch)
hspu_min=0.5 ; %slot hight in pu (from slot pitch)
 
% Dso lax1 hpm lpm_pu hsy_pu ws_pu hs_pu
d1=[2 2 0.5 0.05 0.05 0.05 0.2]; % pu - initial step
d2=[1 0.5 0.2 0.01 0.01 0.01 0.02]; %  final step
ropt=2;     % optimization rate
 
%Technological limitation
Dri_min=32; % mm - Shaft diameter
hry=3;      %mm - rotor yoke is required only for mechanical reason 
hag=0.5;   % mm - Air-gap height
hs4=1;    % mm - Stator tooth pole tip height
hs3=1;  % mm
sMs=3;  % mm -stator mounth opening
hrb=1;  %mm - rotor bridge over PM
hrb2=1.8;
hrb2max=2.5;
hrbarrier=4.5; 
dhpm=0.2; %mm
dlpm=1;    %mm
ksfill=0.4; %slot filling factor
ssf=0.97; %stator lamination stacking factor
Tw1=100;     % Celsius deg. - stator winding average temperature
Tpm=70;      % Celsius deg. - Permanent magnet temperature
Tamb=40;     %      deg.C - temperature of cooling fluid
alpha_t=14.200000; 	 %W/m^2*deg. thermal transmission coefficient
hframe=4;  %mm - frame height 
ksframe=5;

stcore_mat='M19';   % stator laminations features
pm_material='VAC677';    % permanent magnet features
%pm_material='FERRITE_415';    % permanent magnet features
shaft_mat='Steel_1006';
wire_type='Cu';               % allowed: Cu, Al

Dwire=[0.16 0.18 0.20 0.227 0.255 0.286 0.321 0.361 0.40 0.45 0.51 0.57 0.644...
        0.723 0.81 0.91 1.02 1.15 1.29 1.45 1.63 1.83 2.05 2.30];   % mm
 
%Objective function coefficients
cu_pr=7.2; %USD/kg copper price
al_pr=2.8;   %USD/kg aluminum price
lam_pr=1.26; %USD/kg lamination price
PM_pr=50; %USD/kg PM price (50 - Sintered, 15 - Bounded, 6.5 - Ferrite)
rotIron_pr=1.26; %USD/kg - shaft iron price
energy_pr=0.3; %USD/kWh energy price (includes weighting factor in the objective function)
pmw_pr=0.972; %USD/kg passive material price
pconv=15; %USD/kVA penalty on power converter increases due to poor power factor 
hpy=1000; %h hour per year
ny=10; %years of use
ksdemag=2; %demagnetization safety factor
Bpmdemag=0.1;
kcdemag=2; %demagnetization penalty gain
kcthermal=2; %thermal penalty gain
 
krelax=0.25;
eps_desired=1e-3;
 
run_mode='o';
nstart=30; %times to runing optimisation
output_file='m5p10.m'; % output file name
fem_filex='m5p10';
%------------------------------------------------------------------------
