%Input file for thermal analyses

%Geometric dimensions
poles=10;  %  - numbers of poles
nphase=3;
q1=1;
Dro=101; %mm Stator outer diameter
lstack=75.5;%mm axial length
Dso=145;
Dri=32;
hpm=3.45;
wtooth=6;
hsy=5.3;

hry=3;      %mm - rotor yoke is required only for mechanical reason 
hag=0.5;   % mm - Air-gap height
hs4=1;    % mm - Stator tooth pole tip height
hs3=1;  % mm
sMs=3;  % mm -stator mounth opening
hrb=1;  %mm - rotor bridge over PM
hrb2=1.8;
hrb2max=2.5;
hrbarrier=6.5; 
dhpm=0.2; %mm
dlpm=1;    %mm

nce=1;
dco=1.29; %mm
sb=29;
impCond=0.0181; %Air
impHeat=3;

%Convection heat exchange data
Tpm=70;      % Celsius deg. - Permanent magnet temperature
Tamb=40;     %      deg.C - temperature of cooling fluid
alpha_t=14.200000; 	 %W/m^2*deg. thermal transmission coefficient
hframe=4;  %mm - frame height
Nblades=40;
hblades=35;
gblases=3;

%Used mataerial
stcore_mat='M19';   % stator laminations features
pm_material='VAC677';    % permanent magnet features
%pm_material='FERRITE_415';    % permanent magnet features
shaft_mat='Steel_1006';
wire_type='Cu';               % allowed: Cu, Al

%Losses
Pcu=220; %W copper losses
Pfe=50.62;  %W iron losses
slotVol=7.098e-6; %m^3
coreVol=400.86; %m^3
%simulation setings
simrange=1; %n>0 number of simulated poles; n=-1 - single slot

fem_file='mth2p5'