function opt_gtrace(trace_in,rpos)
[i_trace, ns]=size(trace_in);
xg=1:i_trace;

figure
plot(xg,trace_in(:,1),'*',xg,trace_in(:,2),'o');
title('Main dimensions');
ylabel('(mm)');
legend('Dro','lstack');
xlabel('step number')
grid;

figure
plot(xg,trace_in(:,3),'o');
title('PM height');
ylabel('pm (mm)');
xlabel('step number')
grid;

figure
plot(xg,trace_in(:,4),'o',xg,trace_in(:,5),'*',xg,trace_in(:,6),'+',xg,trace_in(:,7),'p');
title('Per unit dimensions');
xlabel('step number');
ylabel('(mm)');
legend('PM length','yoke height ', 'tooth width', 'slot height' );
grid;

figure
plot(xg,trace_in(:,9),'o',xg,trace_in(:,10),'*');
title('Losses Evolution');
xlabel('step number');
ylabel('Losses(W)');
legend('Pcu','Pfe');
grid;

figure
plot(xg,trace_in(:,11),'o');
title('Electric Efficiency Evolution');
xlabel('step number')
grid;

figure
plot(xg,trace_in(:,12),'o',xg,trace_in(:,13),'*');
title('Mass Evolution');
xlabel('step number')
ylabel('(kq)');
legend('PM','Total');
grid;

figure
plot(xg,trace_in(:,8),'o',xg,trace_in(:,14),'*',xg,trace_in(:,15),'+');
title('Objective Function Evolution');
xlabel('step number');
ylabel('Cost (USD)');
legend('total','initial','energy');
grid;